/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.permission;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AddProjectCreatorToTemplateWsRequest {
    private final String templateId;
    private final String organization;
    private final String templateName;
    private final String permission;

    private AddProjectCreatorToTemplateWsRequest(Builder builder) {
        this.templateId = builder.templateId;
        this.organization = builder.organization;
        this.templateName = builder.templateName;
        this.permission = Objects.requireNonNull(builder.permission);
    }

    @CheckForNull
    public String getTemplateId() {
        return this.templateId;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public String getTemplateName() {
        return this.templateName;
    }

    public String getPermission() {
        return this.permission;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String templateId;
        private String organization;
        private String templateName;
        private String permission;

        private Builder() {
        }

        public Builder setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }

        public Builder setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder setPermission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        public AddProjectCreatorToTemplateWsRequest build() {
            return new AddProjectCreatorToTemplateWsRequest(this);
        }
    }
}

