/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.project;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BulkUpdateKeyWsRequest {
    private final String id;
    private final String key;
    private final String from;
    private final String to;
    private final boolean dryRun;

    public BulkUpdateKeyWsRequest(Builder builder) {
        this.id = builder.id;
        this.key = builder.key;
        this.from = builder.from;
        this.to = builder.to;
        this.dryRun = builder.dryRun;
    }

    @CheckForNull
    public String getId() {
        return this.id;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String key;
        private String from;
        private String to;
        private boolean dryRun;

        private Builder() {
        }

        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public Builder setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        public Builder setFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public BulkUpdateKeyWsRequest build() {
            Preconditions.checkArgument((this.from != null && !this.from.isEmpty() ? 1 : 0) != 0, (Object)"The string to match must not be empty");
            Preconditions.checkArgument((this.to != null && !this.to.isEmpty() ? 1 : 0) != 0, (Object)"The string replacement must not be empty");
            return new BulkUpdateKeyWsRequest(this);
        }
    }
}

