/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.project;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CreateRequest {
    private final String organization;
    private final String key;
    private final String name;
    private final String branch;
    @CheckForNull
    private final String visibility;

    private CreateRequest(Builder builder) {
        this.organization = builder.organization;
        this.key = builder.key;
        this.name = builder.name;
        this.branch = builder.branch;
        this.visibility = builder.visibility;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    @CheckForNull
    public String getVisibility() {
        return this.visibility;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organization;
        private String key;
        private String name;
        private String branch;
        @CheckForNull
        private String visibility;

        private Builder() {
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setVisibility(@Nullable String visibility) {
            this.visibility = visibility;
            return this;
        }

        public CreateRequest build() {
            return new CreateRequest(this);
        }
    }
}

