/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualitygate;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UpdateConditionRequest {
    private final long conditionId;
    private final String metricKey;
    private final String operator;
    private final String warning;
    private final String error;
    private final Integer period;

    private UpdateConditionRequest(Builder builder) {
        this.conditionId = builder.conditionId;
        this.metricKey = builder.metricKey;
        this.operator = builder.operator;
        this.warning = builder.warning;
        this.error = builder.error;
        this.period = builder.period;
    }

    public long getConditionId() {
        return this.conditionId;
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public String getOperator() {
        return this.operator;
    }

    @CheckForNull
    public String getWarning() {
        return this.warning;
    }

    @CheckForNull
    public String getError() {
        return this.error;
    }

    @CheckForNull
    public Integer getPeriod() {
        return this.period;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long conditionId;
        private String metricKey;
        private String operator;
        private String warning;
        private String error;
        private Integer period;

        private Builder() {
        }

        public Builder setConditionId(long conditionId) {
            this.conditionId = conditionId;
            return this;
        }

        public Builder setMetricKey(String metricKey) {
            this.metricKey = metricKey;
            return this;
        }

        public Builder setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        public Builder setWarning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        public Builder setError(@Nullable String error) {
            this.error = error;
            return this;
        }

        public Builder setPeriod(@Nullable Integer period) {
            this.period = period;
            return this;
        }

        public UpdateConditionRequest build() {
            Preconditions.checkArgument((this.conditionId > 0L ? 1 : 0) != 0, (Object)"Condition id is mandatory and must not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.metricKey) ? 1 : 0) != 0, (Object)"Metric key is mandatory and must not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.operator) ? 1 : 0) != 0, (Object)"Operator is mandatory and must not be empty");
            return new UpdateConditionRequest(this);
        }
    }
}

