/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualityprofile;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonarqube.ws.Common;

public class ActivateRuleWsRequest {
    private final Optional<String> params;
    private final String key;
    private final Optional<Boolean> reset;
    private final String ruleKey;
    private final Optional<Common.Severity> severity;
    private final Optional<String> organization;

    private ActivateRuleWsRequest(Builder builder) {
        this.organization = Objects.requireNonNull(builder.organization);
        this.params = Objects.requireNonNull(builder.params);
        this.key = Objects.requireNonNull(builder.key);
        this.reset = Objects.requireNonNull(builder.reset);
        this.ruleKey = Objects.requireNonNull(builder.ruleKey);
        this.severity = Objects.requireNonNull(builder.severity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getParams() {
        return this.params;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<Boolean> getReset() {
        return this.reset;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public Optional<Common.Severity> getSeverity() {
        return this.severity;
    }

    public Optional<String> getOrganization() {
        return this.organization;
    }

    public static class Builder {
        private Optional<String> organization = Optional.empty();
        private Optional<String> params = Optional.empty();
        private String key;
        private Optional<Boolean> reset = Optional.empty();
        private String ruleKey;
        private Optional<Common.Severity> severity = Optional.empty();

        private Builder() {
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = Optional.ofNullable(organization);
            return this;
        }

        public Builder setParams(@Nullable String params) {
            this.params = Optional.ofNullable(params);
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setReset(@Nullable Boolean reset) {
            this.reset = Optional.ofNullable(reset);
            return this;
        }

        public Builder setRuleKey(String ruleKey) {
            this.ruleKey = ruleKey;
            return this;
        }

        public Builder setSeverity(@Nullable Common.Severity severity) {
            this.severity = Optional.ofNullable(severity);
            return this;
        }

        public ActivateRuleWsRequest build() {
            return new ActivateRuleWsRequest(this);
        }
    }
}

