/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualityprofile;

import org.sonarqube.ws.QualityProfiles;
import org.sonarqube.ws.client.BaseRequest;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.qualityprofile.ActivateRuleWsRequest;
import org.sonarqube.ws.client.qualityprofile.AddGroupRequest;
import org.sonarqube.ws.client.qualityprofile.AddProjectRequest;
import org.sonarqube.ws.client.qualityprofile.AddUserRequest;
import org.sonarqube.ws.client.qualityprofile.ChangeParentRequest;
import org.sonarqube.ws.client.qualityprofile.ChangelogWsRequest;
import org.sonarqube.ws.client.qualityprofile.CopyRequest;
import org.sonarqube.ws.client.qualityprofile.CreateRequest;
import org.sonarqube.ws.client.qualityprofile.RemoveGroupRequest;
import org.sonarqube.ws.client.qualityprofile.RemoveProjectRequest;
import org.sonarqube.ws.client.qualityprofile.RemoveUserRequest;
import org.sonarqube.ws.client.qualityprofile.RestoreWsRequest;
import org.sonarqube.ws.client.qualityprofile.SearchGroupsRequest;
import org.sonarqube.ws.client.qualityprofile.SearchUsersRequest;
import org.sonarqube.ws.client.qualityprofile.SearchWsRequest;
import org.sonarqube.ws.client.qualityprofile.SetDefaultRequest;
import org.sonarqube.ws.client.qualityprofile.ShowRequest;

public class QualityProfilesService
extends BaseService {
    public QualityProfilesService(WsConnector wsConnector) {
        super(wsConnector, "api/qualityprofiles");
    }

    public void activateRule(ActivateRuleWsRequest request) {
        PostRequest httpRequest = new PostRequest(this.path("activate_rule"));
        httpRequest.setParam("organization", (String)request.getOrganization().orElse(null));
        httpRequest.setParam("params", (String)request.getParams().orElse(null));
        httpRequest.setParam("key", request.getKey());
        httpRequest.setParam("reset", (Boolean)request.getReset().orElse(null));
        httpRequest.setParam("rule", request.getRuleKey());
        httpRequest.setParam("severity", (String)request.getSeverity().map(Enum::name).orElse(null));
        this.call(httpRequest);
    }

    public void deactivateRule(String profileKey, String ruleKey) {
        PostRequest httpRequest = new PostRequest(this.path("deactivate_rule"));
        httpRequest.setParam("key", profileKey);
        httpRequest.setParam("rule", ruleKey);
        this.call(httpRequest);
    }

    public void restoreProfile(RestoreWsRequest request) {
        PostRequest httpRequest = new PostRequest(this.path("restore"));
        httpRequest.setParam("organization", (String)request.getOrganization().orElse(null));
        httpRequest.setPart("backup", new PostRequest.Part("application/xml", request.getBackup()));
        this.call(httpRequest);
    }

    public QualityProfiles.SearchWsResponse search(SearchWsRequest request) {
        return this.call((BaseRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search")).setParam("defaults", request.getDefaults())).setParam("language", request.getLanguage())).setParam("qualityProfile", request.getQualityProfile())).setParam("projectKey", request.getProjectKey())).setParam("organization", request.getOrganizationKey()), QualityProfiles.SearchWsResponse.parser());
    }

    public QualityProfiles.ShowResponse show(ShowRequest request) {
        return this.call((BaseRequest)((GetRequest)new GetRequest(this.path("show")).setParam("key", request.getKey())).setParam("compareToSonarWay", request.getCompareToSonarWay()), QualityProfiles.ShowResponse.parser());
    }

    public void addProject(AddProjectRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_project")).setParam("language", request.getLanguage())).setParam("organization", (String)request.getOrganization().orElse(null))).setParam("qualityProfile", request.getQualityProfile())).setParam("key", request.getKey())).setParam("projectKey", request.getProjectKey())).setParam("projectUuid", request.getProjectUuid()));
    }

    public void removeProject(RemoveProjectRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_project")).setParam("language", request.getLanguage())).setParam("qualityProfile", request.getQualityProfile())).setParam("key", request.getKey())).setParam("projectKey", request.getProjectKey())).setParam("projectUuid", request.getProjectUuid()));
    }

    public QualityProfiles.CreateWsResponse create(CreateRequest request) {
        PostRequest postRequest = (PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("create")).setParam("organization", request.getOrganizationKey())).setParam("language", request.getLanguage())).setParam("name", request.getName());
        return this.call(postRequest, QualityProfiles.CreateWsResponse.parser());
    }

    public QualityProfiles.CopyWsResponse copy(CopyRequest request) {
        PostRequest postRequest = (PostRequest)((PostRequest)new PostRequest(this.path("copy")).setParam("fromKey", request.getFromKey())).setParam("toName", request.getToName());
        return this.call(postRequest, QualityProfiles.CopyWsResponse.parser());
    }

    public void changeParent(ChangeParentRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("change_parent")).setParam("language", request.getLanguage())).setParam("parentKey", request.getParentKey())).setParam("parentQualityProfile", request.getParentQualityProfile())).setParam("key", request.getKey())).setParam("qualityProfile", request.getQualityProfile())).setParam("organization", request.getOrganization()));
    }

    public void setDefault(SetDefaultRequest request) {
        PostRequest postRequest = (PostRequest)new PostRequest(this.path("set_default")).setParam("key", request.getKey());
        this.call(postRequest);
    }

    public void delete(String profileKey) {
        PostRequest postRequest = (PostRequest)new PostRequest(this.path("delete")).setParam("key", profileKey);
        this.call(postRequest);
    }

    public void addUser(AddUserRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_user")).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile())).setParam("language", request.getLanguage())).setParam("login", request.getUserLogin()));
    }

    public void removeUser(RemoveUserRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_user")).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile())).setParam("language", request.getLanguage())).setParam("login", request.getUserLogin()));
    }

    public QualityProfiles.SearchUsersResponse searchUsers(SearchUsersRequest request) {
        return this.call((BaseRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search_users")).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile())).setParam("language", request.getLanguage())).setParam("q", request.getQuery())).setParam("selected", request.getSelected())).setParam("p", request.getPage())).setParam("ps", request.getPageSize()), QualityProfiles.SearchUsersResponse.parser());
    }

    public void addGroup(AddGroupRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_group")).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile())).setParam("language", request.getLanguage())).setParam("group", request.getGroup()));
    }

    public void removeGroup(RemoveGroupRequest request) {
        this.call((WsRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_group")).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile())).setParam("language", request.getLanguage())).setParam("group", request.getGroup()));
    }

    public QualityProfiles.SearchGroupsResponse searchGroups(SearchGroupsRequest request) {
        return this.call((BaseRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search_groups")).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile())).setParam("language", request.getLanguage())).setParam("q", request.getQuery())).setParam("selected", request.getSelected())).setParam("p", request.getPage())).setParam("ps", request.getPageSize()), QualityProfiles.SearchGroupsResponse.parser());
    }

    public String changelog(ChangelogWsRequest request) {
        PostRequest postRequest = (PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("changelog")).setParam("language", request.getLanguage())).setParam("organization", request.getOrganization())).setParam("qualityProfile", request.getQualityProfile());
        if (request.getP() != null) {
            postRequest.setParam("p", request.getP());
        }
        if (request.getPs() != null) {
            postRequest.setParam("ps", request.getPs());
        }
        if (request.getSince() != null) {
            postRequest.setParam("since", request.getSince());
        }
        if (request.getTo() != null) {
            postRequest.setParam("to", request.getTo());
        }
        return this.call(postRequest).content();
    }
}

