/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualityprofile;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RemoveProjectRequest {
    private final String language;
    private final String qualityProfile;
    private final String key;
    private final String projectKey;
    private final String projectUuid;

    private RemoveProjectRequest(Builder builder) {
        this.language = builder.language;
        this.qualityProfile = builder.qualityProfile;
        this.key = builder.key;
        this.projectKey = builder.projectKey;
        this.projectUuid = builder.projectUuid;
    }

    @CheckForNull
    public String getLanguage() {
        return this.language;
    }

    @CheckForNull
    public String getQualityProfile() {
        return this.qualityProfile;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    @CheckForNull
    public String getProjectKey() {
        return this.projectKey;
    }

    @CheckForNull
    public String getProjectUuid() {
        return this.projectUuid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String language;
        private String qualityProfile;
        private String key;
        private String projectKey;
        private String projectUuid;

        private Builder() {
        }

        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder setQualityProfile(@Nullable String qualityProfile) {
            this.qualityProfile = qualityProfile;
            return this;
        }

        public Builder setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        public Builder setProjectKey(@Nullable String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public Builder setProjectUuid(@Nullable String projectUuid) {
            this.projectUuid = projectUuid;
            return this;
        }

        public RemoveProjectRequest build() {
            return new RemoveProjectRequest(this);
        }
    }
}

