/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualityprofile;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class RestoreWsRequest {
    private final File backup;
    private final Optional<String> organization;

    private RestoreWsRequest(Builder builder) {
        this.backup = Objects.requireNonNull(builder.backup);
        this.organization = Objects.requireNonNull(builder.organization);
    }

    public File getBackup() {
        return this.backup;
    }

    public Optional<String> getOrganization() {
        return this.organization;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File backup;
        private Optional<String> organization = Optional.empty();

        public Builder setBackup(File backup) {
            this.backup = backup;
            return this;
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = Optional.ofNullable(organization);
            return this;
        }

        public RestoreWsRequest build() {
            return new RestoreWsRequest(this);
        }
    }
}

