/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualityprofile;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class SearchUsersRequest {
    private String organization;
    private String qualityProfile;
    private String language;
    private String selected;
    private String query;
    private Integer page;
    private Integer pageSize;

    private SearchUsersRequest(Builder builder) {
        this.organization = builder.organization;
        this.qualityProfile = builder.qualityProfile;
        this.language = builder.language;
        this.selected = builder.selected;
        this.query = builder.query;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    public String getQualityProfile() {
        return this.qualityProfile;
    }

    public String getLanguage() {
        return this.language;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public String getSelected() {
        return this.selected;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organization;
        private String qualityProfile;
        private String language;
        private String selected;
        private String query;
        private Integer page;
        private Integer pageSize;

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setQualityProfile(String qualityProfile) {
            this.qualityProfile = qualityProfile;
            return this;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setSelected(String selected) {
            this.selected = selected;
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchUsersRequest build() {
            return new SearchUsersRequest(this);
        }
    }
}

