/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.setting;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class SetRequest {
    private final String key;
    private final String value;
    private final List<String> values;
    private final List<String> fieldValues;
    private final String component;
    private final String branch;

    private SetRequest(Builder builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.values = builder.values;
        this.fieldValues = builder.fieldValues;
        this.component = builder.component;
        this.branch = builder.branch;
    }

    public String getKey() {
        return this.key;
    }

    @CheckForNull
    public String getValue() {
        return this.value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public List<String> getFieldValues() {
        return this.fieldValues;
    }

    @CheckForNull
    public String getComponent() {
        return this.component;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String key;
        private String value;
        private List<String> values = Collections.emptyList();
        private List<String> fieldValues = Collections.emptyList();
        private String component;
        private String branch;

        private Builder() {
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public Builder setValues(List<String> values) {
            this.values = values;
            return this;
        }

        public Builder setFieldValues(List<String> fieldValues) {
            this.fieldValues = fieldValues;
            return this;
        }

        public Builder setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public SetRequest build() {
            Preconditions.checkArgument((this.key != null && !this.key.isEmpty() ? 1 : 0) != 0, (Object)"Setting key is mandatory and must not be empty");
            Preconditions.checkArgument((this.values != null ? 1 : 0) != 0, (Object)"Setting values must not be null");
            Preconditions.checkArgument((this.fieldValues != null ? 1 : 0) != 0, (Object)"Setting fields values must not be null");
            return new SetRequest(this);
        }
    }
}

