/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class UpdateRequest {
    private final String login;
    private final String name;
    private final String email;
    private final List<String> scmAccounts;

    private UpdateRequest(Builder builder) {
        this.login = builder.login;
        this.name = builder.name;
        this.email = builder.email;
        this.scmAccounts = builder.scmAccounts;
    }

    public String getLogin() {
        return this.login;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getEmail() {
        return this.email;
    }

    public List<String> getScmAccounts() {
        return this.scmAccounts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String login;
        private String name;
        private String email;
        private List<String> scmAccounts = Collections.emptyList();

        private Builder() {
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setScmAccounts(List<String> scmAccounts) {
            this.scmAccounts = scmAccounts;
            return this;
        }

        public UpdateRequest build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.login) ? 1 : 0) != 0, (Object)"Login is mandatory and must not be empty");
            return new UpdateRequest(this);
        }
    }
}

