/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.usergroup;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SearchWsRequest {
    private final String query;
    private final Integer page;
    private final Integer pageSize;
    private final String organization;
    private final List<String> fields;

    private SearchWsRequest(Builder builder) {
        this.query = builder.query;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.organization = builder.organization;
        this.fields = builder.fields;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    @CheckForNull
    public Integer getPageSize() {
        return this.pageSize;
    }

    @CheckForNull
    public Integer getPage() {
        return this.page;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public List<String> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String query;
        private Integer page;
        private Integer pageSize;
        private String organization;
        private List<String> fields;

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setFields(@Nullable List<String> fields) {
            this.fields = fields;
            return this;
        }

        public SearchWsRequest build() {
            return new SearchWsRequest(this);
        }
    }
}

