/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.Method;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.util.ReflectionUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;

public class SpringTestContext {
    private static final Method getApplicationContextMethod = ReflectionUtil.getMethodBySignature(TestContext.class, (String)"getApplicationContext", (Class[])new Class[0]);
    private static final Method getTestInstanceMethod = ReflectionUtil.getMethodBySignature(TestContext.class, (String)"getTestInstance", (Class[])new Class[0]);
    private static final Method setAttributeMethod = ReflectionUtil.getMethodBySignature(TestContext.class, (String)"setAttribute", (Class[])new Class[]{String.class, Object.class});
    private static final Method getAttributeMethod = ReflectionUtil.getMethodBySignature(TestContext.class, (String)"getAttribute", (Class[])new Class[]{String.class});
    private final TestContext delegate;

    public SpringTestContext(TestContext testContext) {
        this.delegate = testContext;
    }

    public ApplicationContext getApplicationContext() {
        if (getApplicationContextMethod == null) {
            throw new SpringExtensionException("Method 'TestContext.getApplicationContext()' was not found");
        }
        return (ApplicationContext)ReflectionUtil.invokeMethod((Object)this.delegate, (Method)getApplicationContextMethod, (Object[])new Object[0]);
    }

    public Object getTestInstance() {
        if (getTestInstanceMethod == null) {
            throw new SpringExtensionException("Method 'TestContext.getTestInstance()' was not found");
        }
        return ReflectionUtil.invokeMethod((Object)this.delegate, (Method)getTestInstanceMethod, (Object[])new Object[0]);
    }

    public void setAttribute(String name, Object value) {
        if (setAttributeMethod == null) {
            throw new SpringExtensionException("Method 'TestContext.setAttribute()' was not found");
        }
        ReflectionUtil.invokeMethod((Object)this.delegate, (Method)setAttributeMethod, (Object[])new Object[]{name, value});
    }

    public Object getAttribute(String name) {
        if (getAttributeMethod == null) {
            throw new SpringExtensionException("Method 'TestContext.getAttribute()' was not found");
        }
        return ReflectionUtil.invokeMethod((Object)this.delegate, (Method)getAttributeMethod, (Object[])new Object[]{name});
    }
}

