/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.mistralai.autoconfigure;

import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.mistralai.MistralAiEmbeddingOptions;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.mistralai.autoconfigure.MistralAiParentProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.mistralai.embedding")
public class MistralAiEmbeddingProperties
extends MistralAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.mistralai.embedding";
    public static final String DEFAULT_EMBEDDING_MODEL = MistralAiApi.EmbeddingModel.EMBED.getValue();
    public static final String DEFAULT_ENCODING_FORMAT = "float";
    public MetadataMode metadataMode = MetadataMode.EMBED;
    @NestedConfigurationProperty
    private final MistralAiEmbeddingOptions options = MistralAiEmbeddingOptions.builder().withModel(DEFAULT_EMBEDDING_MODEL).withEncodingFormat("float").build();

    public MistralAiEmbeddingProperties() {
        super.setBaseUrl("https://api.mistral.ai");
    }

    public MistralAiEmbeddingOptions getOptions() {
        return this.options;
    }

    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    public void setMetadataMode(MetadataMode metadataMode) {
        this.metadataMode = metadataMode;
    }
}

