/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.embedding.EmbeddingOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MistralAiEmbeddingOptions
implements EmbeddingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="encoding_format")
    private String encodingFormat;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public Integer getDimensions() {
        return null;
    }

    public static final class Builder {
        protected MistralAiEmbeddingOptions options = new MistralAiEmbeddingOptions();

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withEncodingFormat(String encodingFormat) {
            this.options.setEncodingFormat(encodingFormat);
            return this;
        }

        public MistralAiEmbeddingOptions build() {
            return this.options;
        }
    }
}

