/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultChatModelObservationConvention
implements ChatModelObservationConvention {
    public static final String DEFAULT_NAME = "gen_ai.client.operation";
    private static final KeyValue REQUEST_MODEL_NONE = KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)"none");
    private static final KeyValue RESPONSE_MODEL_NONE = KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.RESPONSE_MODEL, (String)"none");

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getContextualName(ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (StringUtils.hasText((String)options.getModel())) {
            return "%s %s".formatted(context.getOperationMetadata().operationType(), options.getModel());
        }
        return context.getOperationMetadata().operationType();
    }

    public KeyValues getLowCardinalityKeyValues(ChatModelObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.requestModel(context), this.responseModel(context)});
    }

    protected KeyValue aiOperationType(ChatModelObservationContext context) {
        return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(ChatModelObservationContext context) {
        return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue requestModel(ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (StringUtils.hasText((String)options.getModel())) {
            return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)options.getModel());
        }
        return REQUEST_MODEL_NONE;
    }

    protected KeyValue responseModel(ChatModelObservationContext context) {
        if (context.getResponse() != null && ((ChatResponse)context.getResponse()).getMetadata() != null && StringUtils.hasText((String)((ChatResponse)context.getResponse()).getMetadata().getModel())) {
            return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.RESPONSE_MODEL, (String)((ChatResponse)context.getResponse()).getMetadata().getModel());
        }
        return RESPONSE_MODEL_NONE;
    }

    public KeyValues getHighCardinalityKeyValues(ChatModelObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.requestFrequencyPenalty(keyValues, context);
        keyValues = this.requestMaxTokens(keyValues, context);
        keyValues = this.requestPresencePenalty(keyValues, context);
        keyValues = this.requestStopSequences(keyValues, context);
        keyValues = this.requestTemperature(keyValues, context);
        keyValues = this.requestTools(keyValues, context);
        keyValues = this.requestTopK(keyValues, context);
        keyValues = this.requestTopP(keyValues, context);
        keyValues = this.responseFinishReasons(keyValues, context);
        keyValues = this.responseId(keyValues, context);
        keyValues = this.usageInputTokens(keyValues, context);
        keyValues = this.usageOutputTokens(keyValues, context);
        keyValues = this.usageTotalTokens(keyValues, context);
        return keyValues;
    }

    protected KeyValues requestFrequencyPenalty(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options.getFrequencyPenalty() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_FREQUENCY_PENALTY.asString(), String.valueOf(options.getFrequencyPenalty()));
        }
        return keyValues;
    }

    protected KeyValues requestMaxTokens(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options.getMaxTokens() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_MAX_TOKENS.asString(), String.valueOf(options.getMaxTokens()));
        }
        return keyValues;
    }

    protected KeyValues requestPresencePenalty(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options.getPresencePenalty() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_PRESENCE_PENALTY.asString(), String.valueOf(options.getPresencePenalty()));
        }
        return keyValues;
    }

    protected KeyValues requestStopSequences(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (!CollectionUtils.isEmpty(options.getStopSequences())) {
            StringJoiner stopSequencesJoiner = new StringJoiner(", ", "[", "]");
            options.getStopSequences().forEach(value -> stopSequencesJoiner.add("\"" + value + "\""));
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_STOP_SEQUENCES.asString(), stopSequencesJoiner.toString());
        }
        return keyValues;
    }

    protected KeyValues requestTemperature(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options.getTemperature() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_TEMPERATURE.asString(), String.valueOf(options.getTemperature()));
        }
        return keyValues;
    }

    protected KeyValues requestTools(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions chatOptions = ((Prompt)context.getRequest()).getOptions();
        if (!(chatOptions instanceof ToolCallingChatOptions)) {
            return keyValues;
        }
        ToolCallingChatOptions options = (ToolCallingChatOptions)chatOptions;
        HashSet<String> toolNames = new HashSet<String>(options.getToolNames());
        toolNames.addAll(options.getToolCallbacks().stream().map(tc -> tc.getToolDefinition().name()).toList());
        if (!CollectionUtils.isEmpty(toolNames)) {
            StringJoiner toolNamesJoiner = new StringJoiner(", ", "[", "]");
            toolNames.forEach(value -> toolNamesJoiner.add("\"" + value + "\""));
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_TOOL_NAMES.asString(), toolNamesJoiner.toString());
        }
        return keyValues;
    }

    protected KeyValues requestTopK(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options.getTopK() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_TOP_K.asString(), String.valueOf(options.getTopK()));
        }
        return keyValues;
    }

    protected KeyValues requestTopP(KeyValues keyValues, ChatModelObservationContext context) {
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options.getTopP() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_TOP_P.asString(), String.valueOf(options.getTopP()));
        }
        return keyValues;
    }

    protected KeyValues responseFinishReasons(KeyValues keyValues, ChatModelObservationContext context) {
        if (context.getResponse() != null && !CollectionUtils.isEmpty(((ChatResponse)context.getResponse()).getResults())) {
            List<String> finishReasons = ((ChatResponse)context.getResponse()).getResults().stream().filter(generation -> StringUtils.hasText((String)generation.getMetadata().getFinishReason())).map(generation -> generation.getMetadata().getFinishReason()).toList();
            if (CollectionUtils.isEmpty(finishReasons)) {
                return keyValues;
            }
            StringJoiner finishReasonsJoiner = new StringJoiner(", ", "[", "]");
            finishReasons.forEach(finishReason -> finishReasonsJoiner.add("\"" + finishReason + "\""));
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.RESPONSE_FINISH_REASONS.asString(), finishReasonsJoiner.toString());
        }
        return keyValues;
    }

    protected KeyValues responseId(KeyValues keyValues, ChatModelObservationContext context) {
        if (context.getResponse() != null && ((ChatResponse)context.getResponse()).getMetadata() != null && StringUtils.hasText((String)((ChatResponse)context.getResponse()).getMetadata().getId())) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.RESPONSE_ID.asString(), ((ChatResponse)context.getResponse()).getMetadata().getId());
        }
        return keyValues;
    }

    protected KeyValues usageInputTokens(KeyValues keyValues, ChatModelObservationContext context) {
        if (context.getResponse() != null && ((ChatResponse)context.getResponse()).getMetadata() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage().getPromptTokens() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.USAGE_INPUT_TOKENS.asString(), String.valueOf(((ChatResponse)context.getResponse()).getMetadata().getUsage().getPromptTokens()));
        }
        return keyValues;
    }

    protected KeyValues usageOutputTokens(KeyValues keyValues, ChatModelObservationContext context) {
        if (context.getResponse() != null && ((ChatResponse)context.getResponse()).getMetadata() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage().getCompletionTokens() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.USAGE_OUTPUT_TOKENS.asString(), String.valueOf(((ChatResponse)context.getResponse()).getMetadata().getUsage().getCompletionTokens()));
        }
        return keyValues;
    }

    protected KeyValues usageTotalTokens(KeyValues keyValues, ChatModelObservationContext context) {
        if (context.getResponse() != null && ((ChatResponse)context.getResponse()).getMetadata() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage().getTotalTokens() != null) {
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.USAGE_TOTAL_TOKENS.asString(), String.valueOf(((ChatResponse)context.getResponse()).getMetadata().getUsage().getTotalTokens()));
        }
        return keyValues;
    }
}

