/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.audio.tts;

import java.util.Objects;
import org.springframework.ai.audio.tts.TextToSpeechMessage;
import org.springframework.ai.audio.tts.TextToSpeechOptions;
import org.springframework.ai.model.ModelRequest;

public class TextToSpeechPrompt
implements ModelRequest<TextToSpeechMessage> {
    private final TextToSpeechMessage message;
    private TextToSpeechOptions options;

    public TextToSpeechPrompt(String text) {
        this(new TextToSpeechMessage(text), TextToSpeechOptions.builder().build());
    }

    public TextToSpeechPrompt(String text, TextToSpeechOptions options) {
        this(new TextToSpeechMessage(text), options);
    }

    public TextToSpeechPrompt(TextToSpeechMessage message) {
        this(message, TextToSpeechOptions.builder().build());
    }

    public TextToSpeechPrompt(TextToSpeechMessage message, TextToSpeechOptions options) {
        this.message = message;
        this.options = options;
    }

    @Override
    public TextToSpeechMessage getInstructions() {
        return this.message;
    }

    @Override
    public TextToSpeechOptions getOptions() {
        return this.options;
    }

    public void setOptions(TextToSpeechOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextToSpeechPrompt)) {
            return false;
        }
        TextToSpeechPrompt that = (TextToSpeechPrompt)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.options);
    }

    public String toString() {
        return "TextToSpeechPrompt{message=" + String.valueOf(this.message) + ", options=" + String.valueOf(this.options) + "}";
    }
}

