/*
 * Copyright 2023-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ai.openai.aot;

import java.util.Set;

import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import static org.springframework.ai.aot.AiRuntimeHints.findJsonAnnotatedClassesInPackage;

/**
 * The OpenAiRuntimeHints class is responsible for registering runtime hints for OpenAI
 * API classes.
 *
 * @author Josh Long
 * @author Christian Tzolov
 * @author Mark Pollack
 */
public class OpenAiRuntimeHints implements RuntimeHintsRegistrar {

	private static Set<TypeReference> eval(Set<TypeReference> referenceSet) {
		referenceSet.forEach(tr -> System.out.println(tr.toString()));
		return referenceSet;
	}

	@Override
	public void registerHints(@NonNull RuntimeHints hints, @Nullable ClassLoader classLoader) {
		var mcs = MemberCategory.values();
		for (var tr : eval(findJsonAnnotatedClassesInPackage(OpenAiApi.class))) {
			hints.reflection().registerType(tr, mcs);
		}
		for (var tr : eval(findJsonAnnotatedClassesInPackage(OpenAiAudioApi.class))) {
			hints.reflection().registerType(tr, mcs);
		}
		for (var tr : eval(findJsonAnnotatedClassesInPackage(OpenAiImageApi.class))) {
			hints.reflection().registerType(tr, mcs);
		}
	}

}
