/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.template.st;

import org.slf4j.Logger;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.STMessage;

public class Slf4jStErrorListener
implements STErrorListener {
    private final Logger logger;

    Slf4jStErrorListener(Logger logger) {
        this.logger = logger;
    }

    public void compileTimeError(STMessage msg) {
        this.logger.error(msg.toString());
    }

    public void runTimeError(STMessage msg) {
        if (msg.error != ErrorType.NO_SUCH_PROPERTY) {
            this.logger.error(msg.toString());
        } else {
            this.logger.warn(msg.toString());
        }
    }

    public void IOError(STMessage msg) {
        this.logger.error(msg.toString());
    }

    public void internalError(STMessage msg) {
        this.logger.error(msg.toString());
    }
}

