/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.amqp.rabbit.junit.JUnitUtils;
import org.springframework.amqp.rabbit.junit.LogLevels;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.log.LogAccessor;

public class LogLevelsCondition
implements ExecutionCondition,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(LogLevelsCondition.class));
    private static final String STORE_ANNOTATION_KEY = "logLevelsAnnotation";
    private static final String STORE_CONTAINER_KEY = "logLevelsContainer";
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@LogLevels always enabled");
    private final Map<String, Boolean> loggedMethods = new ConcurrentHashMap<String, Boolean>();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)((AnnotatedElement)element.get()), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation mergedAnnotation = annotations.get(LogLevels.class);
        if (mergedAnnotation.isPresent()) {
            LogLevels loglevels = (LogLevels)mergedAnnotation.synthesize();
            ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
            store.put((Object)STORE_ANNOTATION_KEY, (Object)loglevels);
        }
        return ENABLED;
    }

    public void beforeAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        LogLevels logLevels = (LogLevels)store.get((Object)STORE_ANNOTATION_KEY, LogLevels.class);
        if (logLevels != null) {
            store.put((Object)STORE_CONTAINER_KEY, (Object)JUnitUtils.adjustLogLevels(context.getDisplayName(), Arrays.asList(logLevels.classes()), Arrays.asList(logLevels.categories()), Level.toLevel((String)logLevels.level())));
        }
    }

    public void beforeEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        LogLevels logLevels = (LogLevels)store.get((Object)STORE_ANNOTATION_KEY, LogLevels.class);
        if (logLevels != null) {
            if (store.get((Object)STORE_CONTAINER_KEY) == null) {
                store.put((Object)STORE_CONTAINER_KEY, (Object)JUnitUtils.adjustLogLevels(context.getDisplayName(), Arrays.asList(logLevels.classes()), Arrays.asList(logLevels.categories()), Level.toLevel((String)logLevels.level())));
            }
        } else {
            Optional testMethod = context.getTestMethod();
            if (testMethod.isPresent() && this.loggedMethods.putIfAbsent(((Method)testMethod.get()).getName(), Boolean.TRUE) == null) {
                LOGGER.info(() -> "+++++++++++++++++++++++++++++ Begin " + ((Method)testMethod.get()).getName());
            }
        }
    }

    public void afterEach(ExtensionContext context) {
        LogLevels logLevels;
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        JUnitUtils.LevelsContainer container = (JUnitUtils.LevelsContainer)store.get((Object)STORE_CONTAINER_KEY, JUnitUtils.LevelsContainer.class);
        if (container != null && (logLevels = (LogLevels)store.get((Object)STORE_ANNOTATION_KEY, LogLevels.class)) != null) {
            JUnitUtils.revertLevels(context.getDisplayName(), container);
            store.remove((Object)STORE_CONTAINER_KEY);
        }
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        LogLevels logLevels = (LogLevels)store.remove((Object)STORE_ANNOTATION_KEY, LogLevels.class);
        if (logLevels != null) {
            JUnitUtils.LevelsContainer container = (JUnitUtils.LevelsContainer)store.get((Object)STORE_CONTAINER_KEY, JUnitUtils.LevelsContainer.class);
            if (container != null) {
                JUnitUtils.revertLevels(context.getDisplayName(), container);
            }
            store.remove((Object)STORE_CONTAINER_KEY);
        }
        this.loggedMethods.clear();
    }
}

