/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RepublishMessageRecoverer
implements MessageRecoverer {
    private static final int ELLIPSIS_LENGTH = 3;
    public static final String X_EXCEPTION_STACKTRACE = "x-exception-stacktrace";
    public static final String X_EXCEPTION_MESSAGE = "x-exception-message";
    public static final String X_ORIGINAL_EXCHANGE = "x-original-exchange";
    public static final String X_ORIGINAL_ROUTING_KEY = "x-original-routingKey";
    public static final int DEFAULT_FRAME_MAX_HEADROOM = 20000;
    private static final int MAX_EXCEPTION_MESSAGE_SIZE_IN_TRACE = 97;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AmqpTemplate errorTemplate;
    protected final String errorRoutingKey;
    protected final String errorExchangeName;
    private String errorRoutingKeyPrefix = "error.";
    private int frameMaxHeadroom = 20000;
    private volatile Integer maxStackTraceLength = -1;
    private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate) {
        this(errorTemplate, null, null);
    }

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate, String errorExchange) {
        this(errorTemplate, errorExchange, null);
    }

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate, String errorExchange, String errorRoutingKey) {
        Assert.notNull((Object)errorTemplate, (String)"'errorTemplate' cannot be null");
        this.errorTemplate = errorTemplate;
        this.errorExchangeName = errorExchange;
        this.errorRoutingKey = errorRoutingKey;
        if (!(this.errorTemplate instanceof RabbitTemplate)) {
            this.maxStackTraceLength = Integer.MAX_VALUE;
        }
    }

    public RepublishMessageRecoverer errorRoutingKeyPrefix(String errorRoutingKeyPrefix) {
        this.setErrorRoutingKeyPrefix(errorRoutingKeyPrefix);
        return this;
    }

    public RepublishMessageRecoverer frameMaxHeadroom(int headroom) {
        this.frameMaxHeadroom = headroom;
        return this;
    }

    public void setErrorRoutingKeyPrefix(String errorRoutingKeyPrefix) {
        Assert.notNull((Object)errorRoutingKeyPrefix, (String)"'errorRoutingKeyPrefix' cannot be null");
        this.errorRoutingKeyPrefix = errorRoutingKeyPrefix;
    }

    protected String getErrorRoutingKeyPrefix() {
        return this.errorRoutingKeyPrefix;
    }

    public void setDeliveryMode(MessageDeliveryMode deliveryMode) {
        Assert.notNull((Object)deliveryMode, (String)"'deliveryMode' cannot be null");
        this.deliveryMode = deliveryMode;
    }

    protected MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public void recover(Message message, Throwable cause) {
        MessageProperties messageProperties = message.getMessageProperties();
        Map headers = messageProperties.getHeaders();
        String exceptionMessage = cause.getCause() != null ? cause.getCause().getMessage() : cause.getMessage();
        String[] processed = this.processStackTrace(cause, exceptionMessage);
        String stackTraceAsString = processed[0];
        String truncatedExceptionMessage = processed[1];
        if (truncatedExceptionMessage != null) {
            exceptionMessage = truncatedExceptionMessage;
        }
        headers.put(X_EXCEPTION_STACKTRACE, stackTraceAsString);
        headers.put(X_EXCEPTION_MESSAGE, exceptionMessage);
        headers.put(X_ORIGINAL_EXCHANGE, messageProperties.getReceivedExchange());
        headers.put(X_ORIGINAL_ROUTING_KEY, messageProperties.getReceivedRoutingKey());
        Map<? extends String, ?> additionalHeaders = this.additionalHeaders(message, cause);
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders);
        }
        if (messageProperties.getDeliveryMode() == null) {
            messageProperties.setDeliveryMode(this.deliveryMode);
        }
        if (null != this.errorExchangeName) {
            String routingKey = this.errorRoutingKey != null ? this.errorRoutingKey : this.prefixedOriginalRoutingKey(message);
            this.doSend(this.errorExchangeName, routingKey, message);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Republishing failed message to exchange '" + this.errorExchangeName + "' with routing key " + routingKey));
            }
        } else {
            String routingKey = this.prefixedOriginalRoutingKey(message);
            this.doSend(null, routingKey, message);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Republishing failed message to the template's default exchange with routing key " + routingKey));
            }
        }
    }

    protected void doSend(@Nullable String exchange, String routingKey, Message message) {
        if (exchange != null) {
            this.errorTemplate.send(exchange, routingKey, message);
        } else {
            this.errorTemplate.send(routingKey, message);
        }
    }

    private String[] processStackTrace(Throwable cause, String exceptionMessage) {
        int maxStackTraceLen;
        String stackTraceAsString = this.getStackTraceAsString(cause);
        if (this.maxStackTraceLength < 0 && (maxStackTraceLen = RabbitUtils.getMaxFrame(((RabbitTemplate)this.errorTemplate).getConnectionFactory())) > 0) {
            this.maxStackTraceLength = maxStackTraceLen -= this.frameMaxHeadroom;
        }
        return this.truncateIfNecessary(cause, exceptionMessage, stackTraceAsString);
    }

    private String[] truncateIfNecessary(Throwable cause, String exception, String stackTrace) {
        Object truncatedExceptionMessage;
        boolean truncated = false;
        Object stackTraceAsString = stackTrace;
        String exceptionMessage = exception == null ? "" : exception;
        Object object = truncatedExceptionMessage = exceptionMessage.length() <= 97 ? exceptionMessage : exceptionMessage.substring(0, 97) + "...";
        if (this.maxStackTraceLength > 0 && ((String)stackTraceAsString).length() + exceptionMessage.length() > this.maxStackTraceLength) {
            int adjustedStackTraceLen;
            if (!exceptionMessage.equals(truncatedExceptionMessage)) {
                int start = ((String)stackTraceAsString).indexOf(exceptionMessage);
                stackTraceAsString = ((String)stackTraceAsString).substring(0, start) + (String)truncatedExceptionMessage + ((String)stackTraceAsString).substring(start + exceptionMessage.length());
            }
            if ((adjustedStackTraceLen = this.maxStackTraceLength - ((String)truncatedExceptionMessage).length()) > 0) {
                if (((String)stackTraceAsString).length() > adjustedStackTraceLen) {
                    stackTraceAsString = ((String)stackTraceAsString).substring(0, adjustedStackTraceLen);
                    this.logger.warn((Object)"Stack trace in republished message header truncated due to frame_max limitations; consider increasing frame_max on the broker or reduce the stack trace depth", cause);
                    truncated = true;
                } else if (((String)stackTraceAsString).length() + exceptionMessage.length() > this.maxStackTraceLength) {
                    this.logger.warn((Object)"Exception message in republished message header truncated due to frame_max limitations; consider increasing frame_max on the broker or reduce the exception message size", cause);
                    truncatedExceptionMessage = exceptionMessage.substring(0, this.maxStackTraceLength - ((String)stackTraceAsString).length() - 3) + "...";
                    truncated = true;
                }
            }
        }
        return new String[]{stackTraceAsString, truncated ? truncatedExceptionMessage : null};
    }

    protected Map<? extends String, ?> additionalHeaders(Message message, Throwable cause) {
        return null;
    }

    private String prefixedOriginalRoutingKey(Message message) {
        return this.errorRoutingKeyPrefix + message.getMessageProperties().getReceivedRoutingKey();
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }
}

