/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbitmq.client.listener;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.amqp.Publisher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.AmqpAcknowledgment;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.AmqpNackReceivedException;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.listener.support.ContainerUtils;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.rabbitmq.client.AmqpConnectionFactory;
import org.springframework.amqp.rabbitmq.client.RabbitAmqpTemplate;
import org.springframework.amqp.rabbitmq.client.RabbitAmqpUtils;
import org.springframework.amqp.rabbitmq.client.listener.RabbitAmqpMessageListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitAmqpMessageListenerAdapter
extends MessagingMessageListenerAdapter
implements RabbitAmqpMessageListener {
    private @Nullable Collection<MessagePostProcessor> afterReceivePostProcessors;
    private @Nullable RabbitAmqpTemplate rabbitAmqpTemplate;

    public RabbitAmqpMessageListenerAdapter(@Nullable Object bean, @Nullable Method method, boolean returnExceptions, @Nullable RabbitListenerErrorHandler errorHandler, boolean batch) {
        super(bean, method, returnExceptions, errorHandler, batch);
    }

    public void setAfterReceivePostProcessors(Collection<MessagePostProcessor> afterReceivePostProcessors) {
        this.afterReceivePostProcessors = new ArrayList<MessagePostProcessor>(afterReceivePostProcessors);
    }

    public void setConnectionFactory(AmqpConnectionFactory connectionFactory) {
        this.rabbitAmqpTemplate = new RabbitAmqpTemplate(connectionFactory);
    }

    @Override
    public void onAmqpMessage(com.rabbitmq.client.amqp.Message amqpMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Consumer.Context context) {
        org.springframework.amqp.core.Message springMessage = RabbitAmqpUtils.fromAmqpMessage(amqpMessage, context);
        if (this.afterReceivePostProcessors != null) {
            for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                springMessage = processor.postProcessMessage(springMessage);
            }
        }
        try {
            Message messagingMessage = this.toMessagingMessage(springMessage);
            InvocationResult result = this.getHandlerAdapter().invoke(messagingMessage, new Object[]{springMessage, springMessage.getMessageProperties().getAmqpAcknowledgment(), amqpMessage, context});
            if (result.getReturnValue() != null) {
                Assert.notNull((Object)this.rabbitAmqpTemplate, (String)"The 'connectionFactory' must be provided for handling replies.");
                this.handleResult(result, springMessage, null, messagingMessage);
            }
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Failed to invoke listener", (Throwable)ex, new org.springframework.amqp.core.Message[]{springMessage});
        }
    }

    protected void asyncFailure(org.springframework.amqp.core.Message request, @Nullable Channel channel, Throwable t, @Nullable Object source) {
        try {
            this.handleException(request, channel, (Message)source, new ListenerExecutionFailedException("Async Fail", t, new org.springframework.amqp.core.Message[]{request}));
            return;
        }
        catch (Exception exception) {
            this.logger.error((Object)("Future, Mono, or suspend function was completed with an exception for " + String.valueOf(request)), t);
            AmqpAcknowledgment amqpAcknowledgment = request.getMessageProperties().getAmqpAcknowledgment();
            Assert.notNull((Object)amqpAcknowledgment, (String)"'(amqpAcknowledgment' must be provided into request message.");
            if (ContainerUtils.shouldRequeue((boolean)this.isDefaultRequeueRejected(), (Throwable)t, (Log)this.logger)) {
                amqpAcknowledgment.acknowledge(AmqpAcknowledgment.Status.REQUEUE);
            } else {
                amqpAcknowledgment.acknowledge(AmqpAcknowledgment.Status.REJECT);
            }
            return;
        }
    }

    protected void sendResponse(@Nullable Channel channel, Address replyTo, org.springframework.amqp.core.Message messageIn) {
        CompletableFuture<Boolean> sendFuture;
        org.springframework.amqp.core.Message replyMessage = messageIn;
        MessagePostProcessor[] beforeSendReplyPostProcessors = this.getBeforeSendReplyPostProcessors();
        if (beforeSendReplyPostProcessors != null) {
            for (MessagePostProcessor postProcessor : beforeSendReplyPostProcessors) {
                replyMessage = postProcessor.postProcessMessage(replyMessage);
            }
        }
        String replyToExchange = replyTo.getExchangeName();
        String replyToRoutingKey = replyTo.getRoutingKey();
        if (StringUtils.hasText((String)replyToExchange)) {
            sendFuture = this.rabbitAmqpTemplate.send(replyToExchange, replyToRoutingKey, replyMessage);
        } else {
            Assert.hasText((String)replyToRoutingKey, (String)"The 'replyTo' must be provided, in request message or in @SendTo.");
            Publisher publisher = this.rabbitAmqpTemplate.getPublisher();
            com.rabbitmq.client.amqp.Message amqpMessage = publisher.message();
            RabbitAmqpUtils.toAmqpMessage(replyMessage, amqpMessage);
            amqpMessage.to("/queues/" + replyToRoutingKey.replaceFirst("queues/", ""));
            sendFuture = new CompletableFuture();
            publisher.publish(amqpMessage, context -> {
                switch (context.status()) {
                    case ACCEPTED: {
                        sendFuture.complete(true);
                        break;
                    }
                    case REJECTED: 
                    case RELEASED: {
                        sendFuture.completeExceptionally((Throwable)new AmqpNackReceivedException("The message was rejected", messageIn));
                    }
                }
            });
        }
        sendFuture.join();
    }

    protected void basicAck(org.springframework.amqp.core.Message request, @Nullable Channel channel) {
        AmqpAcknowledgment amqpAcknowledgment = request.getMessageProperties().getAmqpAcknowledgment();
        Assert.notNull((Object)amqpAcknowledgment, (String)"'(amqpAcknowledgment' must be provided into request message.");
        amqpAcknowledgment.acknowledge();
    }

    public void onMessageBatch(List<org.springframework.amqp.core.Message> messages) {
        GenericMessage converted;
        AmqpAcknowledgment amqpAcknowledgment = messages.stream().findAny().map(message -> message.getMessageProperties().getAmqpAcknowledgment()).orElse(null);
        if (this.messagingMessageConverter.isAmqpMessageList()) {
            converted = new GenericMessage(messages);
        } else {
            RabbitAmqpMessageListenerAdapter rabbitAmqpMessageListenerAdapter = this;
            List<Message> messagingMessages = messages.stream().map(x$0 -> rabbitAmqpMessageListenerAdapter.toMessagingMessage((org.springframework.amqp.core.Message)x$0)).toList();
            if (this.messagingMessageConverter.isMessageList()) {
                converted = new GenericMessage(messagingMessages);
            } else {
                ArrayList<Object> payloads = new ArrayList<Object>(messages.size());
                for (Message message2 : messagingMessages) {
                    payloads.add(message2.getPayload());
                }
                converted = new GenericMessage(payloads);
            }
        }
        try {
            InvocationResult result = this.getHandlerAdapter().invoke((Message)converted, new Object[]{amqpAcknowledgment});
            if (result.getReturnValue() != null) {
                this.logger.warn((Object)"Replies for batches are not currently supported with RabbitMQ AMQP 1.0 listeners");
            }
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Failed to invoke listener", (Throwable)ex, messages.toArray(new org.springframework.amqp.core.Message[0]));
        }
    }
}

