/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final String ID_KEY = "_id";
    private MongoOperations template;
    private final Object bufferKey;
    private String collection;
    private Mode mode = Mode.UPSERT;
    private List<String> primaryKeys = List.of("_id");

    public MongoItemWriter() {
        this.bufferKey = new Object();
    }

    @Deprecated(since="5.1", forRemoval=true)
    public void setDelete(boolean delete) {
        this.mode = delete ? Mode.REMOVE : Mode.UPSERT;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    protected MongoOperations getTemplate() {
        return this.template;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        Assert.notEmpty(primaryKeys, (String)"The primaryKeys list must have one or more keys.");
        this.primaryKeys = primaryKeys;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        if (!this.transactionActive()) {
            this.doWrite(chunk);
            return;
        }
        Chunk<T> bufferedItems = this.getCurrentBuffer();
        bufferedItems.addAll(chunk.getItems());
    }

    protected void doWrite(Chunk<? extends T> chunk) {
        if (!chunk.isEmpty()) {
            switch (this.mode) {
                case INSERT: {
                    this.insert(chunk);
                    break;
                }
                case REMOVE: {
                    this.remove(chunk);
                    break;
                }
                default: {
                    this.upsert(chunk);
                }
            }
        }
    }

    private void insert(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            bulkOperations.insert((Object)document);
        }
        bulkOperations.execute();
    }

    private void remove(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            List<Criteria> criteriaList = this.primaryKeys.stream().filter(arg_0 -> ((Document)document).containsKey(arg_0)).map(key -> Criteria.where((String)key).is(document.get(key))).collect(Collectors.toList());
            if (criteriaList.isEmpty()) continue;
            Query query = new Query();
            criteriaList.forEach(arg_0 -> ((Query)query).addCriteria(arg_0));
            bulkOperations.remove(query);
        }
        bulkOperations.execute();
    }

    private void upsert(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        FindAndReplaceOptions upsert = new FindAndReplaceOptions().upsert();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Query query = new Query();
            List<Criteria> criteriaList = this.primaryKeys.stream().filter(arg_0 -> ((Document)document).containsKey(arg_0)).map(key -> Criteria.where((String)key).is(document.get(key))).collect(Collectors.toList());
            if (criteriaList.isEmpty()) {
                Object objectId = document.get((Object)ID_KEY) != null ? document.get((Object)ID_KEY) : new ObjectId();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            } else {
                criteriaList.forEach(arg_0 -> ((Query)query).addCriteria(arg_0));
            }
            bulkOperations.replaceOne(query, (Object)document, upsert);
        }
        bulkOperations.execute();
    }

    private BulkOperations initBulkOperations(BulkOperations.BulkMode bulkMode, Object item) {
        BulkOperations bulkOperations = StringUtils.hasText((String)this.collection) ? this.template.bulkOps(bulkMode, this.collection) : this.template.bulkOps(bulkMode, ClassUtils.getUserClass((Object)item));
        return bulkOperations;
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    @Nullable
    private Chunk<T> getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.bufferKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.bufferKey, new Chunk<Object>(new Object[0]));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void beforeCommit(boolean readOnly) {
                    Chunk chunk = (Chunk)TransactionSynchronizationManager.getResource((Object)MongoItemWriter.this.bufferKey);
                    if (!chunk.isEmpty() && !readOnly) {
                        MongoItemWriter.this.doWrite(chunk);
                    }
                }

                public void afterCompletion(int status) {
                    if (TransactionSynchronizationManager.hasResource((Object)MongoItemWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource((Object)MongoItemWriter.this.bufferKey);
                    }
                }
            });
        }
        return (Chunk)TransactionSynchronizationManager.getResource((Object)this.bufferKey);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.template != null ? 1 : 0) != 0, (String)"A MongoOperations implementation is required.");
    }

    public static enum Mode {
        INSERT,
        UPSERT,
        REMOVE;

    }
}

