/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.data.builder;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.data.RepositoryItemWriter;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;

public class RepositoryItemWriterBuilder<T> {
    private static final Log logger = LogFactory.getLog((String)RepositoryItemWriterBuilder.class.getName());
    private @Nullable CrudRepository<T, ?> repository;
    private @Nullable String methodName;
    private @Nullable RepositoryMethodReference repositoryMethodReference;

    public RepositoryItemWriterBuilder<T> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public RepositoryItemWriterBuilder<T> repository(CrudRepository<T, ?> repository) {
        this.repository = repository;
        return this;
    }

    public RepositoryItemWriterBuilder<T> repository(RepositoryMethodReference repositoryMethodReference) {
        this.repositoryMethodReference = repositoryMethodReference;
        return this;
    }

    public RepositoryItemWriter<T> build() {
        if (this.repositoryMethodReference != null) {
            this.methodName = this.repositoryMethodReference.getMethodName();
            this.repository = this.repositoryMethodReference.getRepository();
        }
        Assert.notNull(this.repository, (String)"repository is required.");
        RepositoryItemWriter<T> writer = new RepositoryItemWriter<T>(this.repository);
        writer.setRepository(this.repository);
        if (this.methodName != null) {
            Assert.hasText((String)this.methodName, (String)"methodName must not be empty.");
            writer.setMethodName(this.methodName);
        } else {
            logger.debug((Object)"No method name provided, CrudRepository.saveAll will be used.");
        }
        return writer;
    }

    public static class RepositoryMethodReference<T> {
        private final RepositoryMethodInterceptor repositoryInvocationHandler = new RepositoryMethodInterceptor();
        private final CrudRepository<?, ?> repository;

        public RepositoryMethodReference(CrudRepository<?, ?> repository) {
            this.repository = repository;
        }

        public T methodIs() {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(this.repository.getClass());
            enhancer.setCallback((Callback)this.repositoryInvocationHandler);
            return (T)enhancer.create();
        }

        CrudRepository<?, ?> getRepository() {
            return this.repository;
        }

        String getMethodName() {
            return this.repositoryInvocationHandler.getMethodName();
        }
    }

    private static class RepositoryMethodInterceptor
    implements MethodInterceptor {
        private @Nullable String methodName;

        private RepositoryMethodInterceptor() {
        }

        public @Nullable Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) {
            this.methodName = method.getName();
            return null;
        }

        @Nullable String getMethodName() {
            return this.methodName;
        }
    }
}

