/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.builder;

import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.JpaCursorItemReader;
import org.springframework.batch.infrastructure.item.database.orm.JpaQueryProvider;
import org.springframework.util.Assert;

public class JpaCursorItemReaderBuilder<T> {
    private @Nullable EntityManagerFactory entityManagerFactory;
    private @Nullable String queryString;
    private @Nullable JpaQueryProvider queryProvider;
    private @Nullable Map<String, Object> parameterValues;
    private @Nullable Map<String, Object> hintValues;
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public JpaCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> hintValues(Map<String, Object> hintValues) {
        this.hintValues = hintValues;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> queryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> entityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        return this;
    }

    public JpaCursorItemReader<T> build() {
        Assert.notNull((Object)this.entityManagerFactory, (String)"An EntityManagerFactory is required");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        if (this.queryProvider == null) {
            Assert.hasLength((String)this.queryString, (String)"Query string is required when queryProvider is null");
        }
        JpaCursorItemReader reader = new JpaCursorItemReader(this.entityManagerFactory);
        if (this.queryProvider != null) {
            reader.setQueryProvider(this.queryProvider);
        }
        if (this.queryString != null) {
            reader.setQueryString(this.queryString);
        }
        if (this.parameterValues != null) {
            reader.setParameterValues(this.parameterValues);
        }
        if (this.hintValues != null) {
            reader.setHintValues(this.hintValues);
        }
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setSaveState(this.saveState);
        if (this.name != null) {
            reader.setName(this.name);
        }
        return reader;
    }
}

