/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.validator;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemProcessor;
import org.springframework.batch.infrastructure.item.validator.ValidationException;
import org.springframework.batch.infrastructure.item.validator.Validator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ValidatingItemProcessor<T>
implements ItemProcessor<T, T>,
InitializingBean {
    private @Nullable Validator<? super T> validator;
    private boolean filter = false;

    public ValidatingItemProcessor() {
    }

    public ValidatingItemProcessor(Validator<? super T> validator) {
        this.validator = validator;
    }

    public void setValidator(Validator<? super T> validator) {
        this.validator = validator;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    @Override
    public @Nullable T process(T item) throws ValidationException {
        try {
            this.validator.validate(item);
        }
        catch (ValidationException e) {
            if (this.filter) {
                return null;
            }
            throw e;
        }
        return item;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.validator != null ? 1 : 0) != 0, (String)"Validator must not be null.");
    }
}

