/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.jackson.EndpointObjectMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.ClassUtils;

@AutoConfiguration
public final class JacksonEndpointAutoConfiguration {
    private static final String CONTRIBUTED_HEALTH = "org.springframework.boot.health.contributor.ContributedHealth";

    @Bean
    @ConditionalOnBooleanProperty(name={"management.endpoints.jackson.isolated-object-mapper"}, matchIfMissing=true)
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    EndpointObjectMapper endpointObjectMapper() {
        final ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().featuresToEnable(new Object[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS}).serializationInclusion(JsonInclude.Include.NON_NULL).build();
        final HashSet<Class> supportedTypes = new HashSet<Class>(EndpointObjectMapper.DEFAULT_SUPPORTED_TYPES);
        if (ClassUtils.isPresent((String)CONTRIBUTED_HEALTH, null)) {
            supportedTypes.add(ClassUtils.resolveClassName((String)CONTRIBUTED_HEALTH, null));
        }
        return new EndpointObjectMapper(){
            final /* synthetic */ JacksonEndpointAutoConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            public ObjectMapper get() {
                return objectMapper;
            }

            public Set<Class<?>> getSupportedTypes() {
                return supportedTypes;
            }
        };
    }
}

