/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.management.MBeanServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.LazyInitializationExcludeFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.DefaultEndpointObjectNameFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.OperationFilter;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.ExposableJmxEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.JacksonJmxOperationResponseMapper;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointExporter;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperationResponseMapper;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

@AutoConfiguration(after={JmxAutoConfiguration.class, EndpointAutoConfiguration.class})
@EnableConfigurationProperties(value={JmxEndpointProperties.class, JmxProperties.class})
@ConditionalOnBooleanProperty(value={"spring.jmx.enabled"})
public final class JmxEndpointAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final JmxEndpointProperties properties;
    private final JmxProperties jmxProperties;

    JmxEndpointAutoConfiguration(ApplicationContext applicationContext, JmxEndpointProperties properties, JmxProperties jmxProperties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
        this.jmxProperties = jmxProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JmxEndpointsSupplier.class})
    JmxEndpointDiscoverer jmxAnnotationEndpointDiscoverer(ParameterValueMapper parameterValueMapper, ObjectProvider<OperationInvokerAdvisor> invokerAdvisors, ObjectProvider<EndpointFilter<ExposableJmxEndpoint>> endpointFilters, ObjectProvider<OperationFilter<JmxOperation>> operationFilters) {
        return new JmxEndpointDiscoverer(this.applicationContext, parameterValueMapper, invokerAdvisors.orderedStream().toList(), endpointFilters.orderedStream().toList(), operationFilters.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean(value={EndpointObjectNameFactory.class}, search=SearchStrategy.CURRENT)
    DefaultEndpointObjectNameFactory endpointObjectNameFactory(MBeanServer mBeanServer) {
        String contextId = ObjectUtils.getIdentityHexString((Object)this.applicationContext);
        return new DefaultEndpointObjectNameFactory(this.properties, this.jmxProperties, mBeanServer, contextId);
    }

    @Bean
    @ConditionalOnSingleCandidate(value=MBeanServer.class)
    JmxEndpointExporter jmxMBeanExporter(MBeanServer mBeanServer, EndpointObjectNameFactory endpointObjectNameFactory, ObjectProvider<ObjectMapper> objectMapper, JmxEndpointsSupplier jmxEndpointsSupplier) {
        JacksonJmxOperationResponseMapper responseMapper = new JacksonJmxOperationResponseMapper((ObjectMapper)objectMapper.getIfAvailable());
        return new JmxEndpointExporter(mBeanServer, endpointObjectNameFactory, (JmxOperationResponseMapper)responseMapper, jmxEndpointsSupplier.getEndpoints());
    }

    @Bean
    IncludeExcludeEndpointFilter<ExposableJmxEndpoint> jmxIncludeExcludePropertyEndpointFilter() {
        JmxEndpointProperties.Exposure exposure = this.properties.getExposure();
        return new IncludeExcludeEndpointFilter<ExposableJmxEndpoint>(ExposableJmxEndpoint.class, exposure.getInclude(), exposure.getExclude(), EndpointExposure.JMX.getDefaultIncludes());
    }

    @Bean
    static LazyInitializationExcludeFilter eagerlyInitializeJmxEndpointExporter() {
        return LazyInitializationExcludeFilter.forBeanTypes((Class[])new Class[]{JmxEndpointExporter.class});
    }

    @Bean
    OperationFilter<JmxOperation> jmxAccessPropertiesOperationFilter(EndpointAccessResolver endpointAccessResolver) {
        return OperationFilter.byAccess((EndpointAccessResolver)endpointAccessResolver);
    }
}

