/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;

public class DropwizardMetricServices
implements CounterService,
GaugeService {
    private final MetricRegistry registry;
    private final ConcurrentMap<String, SimpleGauge> gauges = new ConcurrentHashMap<String, SimpleGauge>();
    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap();

    public DropwizardMetricServices(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void increment(String name) {
        this.incrementInternal(name, 1L);
    }

    @Override
    public void decrement(String name) {
        this.incrementInternal(name, -1L);
    }

    private void incrementInternal(String name, long value) {
        if (name.startsWith("meter")) {
            Meter meter = this.registry.meter(name);
            meter.mark(value);
        } else {
            name = this.wrapCounterName(name);
            Counter counter = this.registry.counter(name);
            counter.inc(value);
        }
    }

    @Override
    public void submit(String name, double value) {
        if (name.startsWith("histogram")) {
            long longValue = (long)value;
            Histogram metric = this.registry.histogram(name);
            metric.update(longValue);
        } else if (name.startsWith("timer")) {
            long longValue = (long)value;
            Timer metric = this.registry.timer(name);
            metric.update(longValue, TimeUnit.MILLISECONDS);
        } else {
            name = this.wrapGaugeName(name);
            this.setGaugeValue(name, value);
        }
    }

    private void setGaugeValue(String name, double value) {
        SimpleGauge newGauge;
        SimpleGauge gauge = (SimpleGauge)this.gauges.get(name);
        if (gauge == null && (gauge = this.gauges.putIfAbsent(name, newGauge = new SimpleGauge(value))) == null) {
            this.registry.register(name, (Metric)newGauge);
            return;
        }
        gauge.setValue(value);
    }

    private String wrapGaugeName(String metricName) {
        return this.wrapName(metricName, "gauge.");
    }

    private String wrapCounterName(String metricName) {
        return this.wrapName(metricName, "counter.");
    }

    private String wrapName(String metricName, String prefix) {
        String cached = this.names.get(metricName);
        if (cached != null) {
            return cached;
        }
        if (metricName.startsWith(prefix)) {
            return metricName;
        }
        String name = prefix + metricName;
        this.names.put(metricName, name);
        return name;
    }

    @Override
    public void reset(String name) {
        if (!name.startsWith("meter")) {
            name = this.wrapCounterName(name);
        }
        this.registry.remove(name);
    }

    private static final class SimpleGauge
    implements Gauge<Double> {
        private volatile double value;

        private SimpleGauge(double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }
}

