/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricMessage;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public final class MetricWriterMessageHandler
implements MessageHandler {
    private static final Log logger = LogFactory.getLog(MetricWriterMessageHandler.class);
    private final MetricWriter observer;

    public MetricWriterMessageHandler(MetricWriter observer) {
        this.observer = observer;
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        this.handleMessage(new MetricMessage(message));
    }

    private void handleMessage(MetricMessage message) {
        Object payload = message.getPayload();
        if (message.isReset()) {
            this.observer.reset(message.getMetricName());
        } else if (payload instanceof Delta) {
            Delta value = (Delta)payload;
            this.observer.increment(value);
        } else if (payload instanceof Metric) {
            Metric value = (Metric)payload;
            this.observer.set(value);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Unsupported metric payload " + (payload == null ? "null" : payload.getClass().getName())));
        }
    }
}

