/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.mappings;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.web.mappings.MappingDescriptionProvider;
import org.springframework.context.ApplicationContext;

@Endpoint(id="mappings")
public class MappingsEndpoint {
    private final Collection<MappingDescriptionProvider> descriptionProviders;
    private final ApplicationContext context;

    public MappingsEndpoint(Collection<MappingDescriptionProvider> descriptionProviders, ApplicationContext context) {
        this.descriptionProviders = descriptionProviders;
        this.context = context;
    }

    @ReadOperation
    public ApplicationMappingsDescriptor mappings() {
        HashMap<@Nullable String, ContextMappingsDescriptor> contextMappings = new HashMap<String, ContextMappingsDescriptor>();
        for (ApplicationContext target = this.context; target != null; target = target.getParent()) {
            contextMappings.put(target.getId(), this.mappingsForContext(target));
        }
        return new ApplicationMappingsDescriptor(contextMappings);
    }

    private ContextMappingsDescriptor mappingsForContext(ApplicationContext applicationContext) {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        this.descriptionProviders.forEach(provider -> mappings.put(provider.getMappingName(), provider.describeMappings(applicationContext)));
        return new ContextMappingsDescriptor(mappings, applicationContext.getParent() != null ? applicationContext.getId() : null);
    }

    public static final class ContextMappingsDescriptor {
        private final Map<String, Object> mappings;
        private final @Nullable String parentId;

        private ContextMappingsDescriptor(Map<String, Object> mappings, @Nullable String parentId) {
            this.mappings = mappings;
            this.parentId = parentId;
        }

        public @Nullable String getParentId() {
            return this.parentId;
        }

        public Map<String, Object> getMappings() {
            return this.mappings;
        }
    }

    public static final class ApplicationMappingsDescriptor
    implements OperationResponseBody {
        private final Map<@Nullable String, ContextMappingsDescriptor> contextMappings;

        private ApplicationMappingsDescriptor(Map<@Nullable String, ContextMappingsDescriptor> contextMappings) {
            this.contextMappings = contextMappings;
        }

        public Map<@Nullable String, ContextMappingsDescriptor> getContexts() {
            return this.contextMappings;
        }
    }
}

