/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.endpoint.web;

import java.util.List;

import org.jspecify.annotations.Nullable;

import org.springframework.boot.actuate.endpoint.EndpointId;

/**
 * Strategy interface used to provide a mapping between an endpoint ID and any additional
 * paths where it will be exposed.
 *
 * @author Phillip Webb
 * @since 3.4.0
 */
@FunctionalInterface
public interface AdditionalPathsMapper {

	/**
	 * Resolve the additional paths for the specified {@code endpointId} and web server
	 * namespace.
	 * @param endpointId the id of an endpoint
	 * @param webServerNamespace the web server namespace
	 * @return the additional paths of the endpoint or {@code null} if this mapper doesn't
	 * support the given endpoint ID.
	 */
	@Nullable List<String> getAdditionalPaths(EndpointId endpointId, WebServerNamespace webServerNamespace);

}
