/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.buildpack.platform.docker.transport.Errors;
import org.springframework.boot.buildpack.platform.docker.transport.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DockerEngineException
extends RuntimeException {
    private final int statusCode;
    private final String reasonPhrase;
    private final Errors errors;
    private final Message responseMessage;

    @Deprecated(since="3.4.12", forRemoval=true)
    public DockerEngineException(String host, URI uri, int statusCode, String reasonPhrase, Errors errors, Message responseMessage) {
        this(host, uri, statusCode, reasonPhrase, errors, responseMessage, null);
    }

    DockerEngineException(String host, URI uri, int statusCode, String reasonPhrase, Errors errors, Message responseMessage, byte[] content) {
        super(DockerEngineException.buildMessage(host, uri, statusCode, reasonPhrase, errors, responseMessage, content));
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.errors = errors;
        this.responseMessage = responseMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    private static String buildMessage(String host, URI uri, int statusCode, String reasonPhrase, Errors errors, Message responseMessage, byte[] content) {
        Assert.notNull((Object)host, (String)"'host' must not be null");
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        StringBuilder message = new StringBuilder("Docker API call to '" + host + String.valueOf(uri) + "' failed with status code " + statusCode);
        if (StringUtils.hasLength((String)reasonPhrase)) {
            message.append(" \"").append(reasonPhrase).append("\"");
        }
        if (responseMessage != null && StringUtils.hasLength((String)responseMessage.getMessage())) {
            message.append(" and message \"").append(responseMessage.getMessage()).append("\"");
        } else if (statusCode == 407 && !ObjectUtils.isEmpty((Object)content)) {
            String contentString = new String(content, StandardCharsets.UTF_8);
            message.append(" and content \"").append(contentString.trim()).append("\"");
        }
        if (errors != null && !errors.isEmpty()) {
            message.append(" ").append(errors);
        }
        return message.toString();
    }
}

