/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.util.Assert;

public class ContainerStatus
extends MappedObject {
    private final int statusCode;
    private final @Nullable String waitingErrorMessage;

    ContainerStatus(int statusCode, @Nullable String waitingErrorMessage) {
        super((JsonNode)NullNode.getInstance(), MethodHandles.lookup());
        this.statusCode = statusCode;
        this.waitingErrorMessage = waitingErrorMessage;
    }

    ContainerStatus(JsonNode node) {
        super(node, MethodHandles.lookup());
        this.statusCode = this.extractStatusCode();
        this.waitingErrorMessage = this.valueAt("/Error/Message", String.class);
    }

    private Integer extractStatusCode() {
        Integer result = this.valueAt("/StatusCode", Integer.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public @Nullable String getWaitingErrorMessage() {
        return this.waitingErrorMessage;
    }

    public static ContainerStatus of(InputStream content) throws IOException {
        return ContainerStatus.of(content, ContainerStatus::new);
    }

    public static ContainerStatus of(int statusCode, @Nullable String errorMessage) {
        return new ContainerStatus(statusCode, errorMessage);
    }
}

