/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.math.BigInteger;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public final class LayerId {
    private final String value;
    private final String algorithm;
    private final String hash;

    private LayerId(String value, String algorithm, String hash) {
        this.value = value;
        this.algorithm = algorithm;
        this.hash = hash;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((LayerId)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public static LayerId of(String value) {
        Assert.hasText((String)value, (String)"'value' must not be empty");
        int i = value.indexOf(58);
        Assert.isTrue((i >= 0 ? 1 : 0) != 0, () -> "'value' [%s] must contain a valid layer ID".formatted(value));
        return new LayerId(value, value.substring(0, i), value.substring(i + 1));
    }

    public static LayerId ofSha256Digest(byte[] digest) {
        Assert.notNull((Object)digest, (String)"'digest' must not be null");
        Assert.isTrue((digest.length == 32 ? 1 : 0) != 0, (String)"'digest' must be exactly 32 bytes");
        String algorithm = "sha256";
        String hash = String.format("%064x", new BigInteger(1, digest));
        return new LayerId(algorithm + ":" + hash, algorithm, hash);
    }
}

