/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.remote.client;

import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class HttpHeaderInterceptor
implements ClientHttpRequestInterceptor {
    private final String name;
    private final String value;

    public HttpHeaderInterceptor(String name, String value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.hasLength((String)value, (String)"'value' must not be empty");
        this.name = name;
        this.value = value;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        request.getHeaders().add(this.name, this.value);
        return execution.execute(request, body);
    }
}

