/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.activemq;

import org.springframework.boot.autoconfigure.jms.artemis.ArtemisConnectionDetails;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisMode;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.activemq.ArtemisEnvironment;

class ArtemisDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ArtemisConnectionDetails> {
    private static final int ACTIVEMQ_PORT = 61616;

    protected ArtemisDockerComposeConnectionDetailsFactory() {
        super("apache/activemq-artemis", new String[0]);
    }

    @Override
    protected ArtemisConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ArtemisDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ArtemisDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ArtemisConnectionDetails {
        private final ArtemisEnvironment environment;
        private final String brokerUrl;

        protected ArtemisDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new ArtemisEnvironment(service.env());
            this.brokerUrl = "tcp://" + service.host() + ":" + service.ports().get(61616);
        }

        public ArtemisMode getMode() {
            return ArtemisMode.NATIVE;
        }

        public String getBrokerUrl() {
            return this.brokerUrl;
        }

        public String getUser() {
            return this.environment.getUser();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }
    }
}

