/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributors;
import org.springframework.lang.Contract;

class ReactiveHealthContributorsAdapter
implements HealthContributors {
    private final ReactiveHealthContributors delegate;

    ReactiveHealthContributorsAdapter(ReactiveHealthContributors delegate) {
        this.delegate = delegate;
    }

    @Override
    public @Nullable HealthContributor getContributor(String name) {
        return this.adapt(this.delegate.getContributor(name));
    }

    @Override
    public Stream<HealthContributors.Entry> stream() {
        return this.delegate.stream().map(entry -> new HealthContributors.Entry(entry.name(), this.adapt(entry.contributor())));
    }

    @Contract(value="!null -> !null")
    private @Nullable HealthContributor adapt(@Nullable ReactiveHealthContributor contributor) {
        return contributor != null ? contributor.asHealthContributor() : null;
    }
}

