/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.metadata;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.boot.jdbc.metadata.AbstractDataSourcePoolMetadata;

public class HikariDataSourcePoolMetadata
extends AbstractDataSourcePoolMetadata<HikariDataSource> {
    public HikariDataSourcePoolMetadata(HikariDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public @Nullable Integer getActive() {
        try {
            HikariPool hikariPool = this.getHikariPool();
            return hikariPool != null ? Integer.valueOf(hikariPool.getActiveConnections()) : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public @Nullable Integer getIdle() {
        try {
            HikariPool hikariPool = this.getHikariPool();
            return hikariPool != null ? Integer.valueOf(hikariPool.getIdleConnections()) : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private @Nullable HikariPool getHikariPool() {
        return (HikariPool)new DirectFieldAccessor(this.getDataSource()).getPropertyValue("pool");
    }

    @Override
    public Integer getMax() {
        return ((HikariDataSource)this.getDataSource()).getMaximumPoolSize();
    }

    @Override
    public Integer getMin() {
        return ((HikariDataSource)this.getDataSource()).getMinimumIdle();
    }

    @Override
    public String getValidationQuery() {
        return ((HikariDataSource)this.getDataSource()).getConnectionTestQuery();
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return ((HikariDataSource)this.getDataSource()).isAutoCommit();
    }
}

