/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase.autoconfigure;

import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.liquibase.actuate.endpoint.LiquibaseEndpoint;
import org.springframework.boot.liquibase.autoconfigure.DataSourceClosingSpringLiquibase;
import org.springframework.boot.liquibase.autoconfigure.LiquibaseAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={LiquibaseAutoConfiguration.class})
@ConditionalOnClass(value={SpringLiquibase.class, LiquibaseEndpoint.class, ConditionalOnAvailableEndpoint.class})
@ConditionalOnAvailableEndpoint(value=LiquibaseEndpoint.class)
public final class LiquibaseEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={SpringLiquibase.class})
    @ConditionalOnMissingBean
    LiquibaseEndpoint liquibaseEndpoint(ApplicationContext context) {
        return new LiquibaseEndpoint(context);
    }

    @Bean
    @ConditionalOnBean(value={SpringLiquibase.class})
    static BeanPostProcessor preventDataSourceCloseBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DataSourceClosingSpringLiquibase) {
                    DataSourceClosingSpringLiquibase dataSource = (DataSourceClosingSpringLiquibase)((Object)bean);
                    dataSource.setCloseDataSourceOnceMigrated(false);
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }
}

