/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import org.apache.maven.plugin.logging.Log;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.BuilderDockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryAuthentication;
import org.springframework.util.Assert;

public class Docker {
    private @Nullable String host;
    private @Nullable String context;
    private boolean tlsVerify;
    private @Nullable String certPath;
    private boolean bindHostToBuilder;
    private @Nullable DockerRegistry builderRegistry;
    private @Nullable DockerRegistry publishRegistry;

    public @Nullable String getHost() {
        return this.host;
    }

    void setHost(@Nullable String host) {
        this.host = host;
    }

    public @Nullable String getContext() {
        return this.context;
    }

    public void setContext(@Nullable String context) {
        this.context = context;
    }

    public boolean isTlsVerify() {
        return this.tlsVerify;
    }

    void setTlsVerify(boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public @Nullable String getCertPath() {
        return this.certPath;
    }

    void setCertPath(@Nullable String certPath) {
        this.certPath = certPath;
    }

    public boolean isBindHostToBuilder() {
        return this.bindHostToBuilder;
    }

    void setBindHostToBuilder(boolean bindHostToBuilder) {
        this.bindHostToBuilder = bindHostToBuilder;
    }

    @Nullable DockerRegistry getBuilderRegistry() {
        return this.builderRegistry;
    }

    void setBuilderRegistry(@Nullable DockerRegistry builderRegistry) {
        this.builderRegistry = builderRegistry;
    }

    @Nullable DockerRegistry getPublishRegistry() {
        return this.publishRegistry;
    }

    void setPublishRegistry(@Nullable DockerRegistry builderRegistry) {
        this.publishRegistry = builderRegistry;
    }

    BuilderDockerConfiguration asDockerConfiguration(Log log, boolean publish) {
        BuilderDockerConfiguration dockerConfiguration = new BuilderDockerConfiguration();
        dockerConfiguration = this.customizeHost(dockerConfiguration);
        dockerConfiguration = dockerConfiguration.withBindHostToBuilder(this.bindHostToBuilder);
        dockerConfiguration = this.customizeBuilderAuthentication(log, dockerConfiguration);
        dockerConfiguration = this.customizePublishAuthentication(log, dockerConfiguration, publish);
        return dockerConfiguration;
    }

    private BuilderDockerConfiguration customizeHost(BuilderDockerConfiguration dockerConfiguration) {
        if (this.context != null && this.host != null) {
            throw new IllegalArgumentException("Invalid Docker configuration, either context or host can be provided but not both");
        }
        if (this.context != null) {
            return dockerConfiguration.withContext(this.context);
        }
        if (this.host != null) {
            return dockerConfiguration.withHost(this.host, this.tlsVerify, this.certPath);
        }
        return dockerConfiguration;
    }

    private BuilderDockerConfiguration customizeBuilderAuthentication(Log log, BuilderDockerConfiguration dockerConfiguration) {
        DockerRegistryAuthentication authentication = DockerRegistryAuthentication.configuration(null, (message, ex) -> log.warn((CharSequence)message));
        return dockerConfiguration.withBuilderRegistryAuthentication(this.getRegistryAuthentication("builder", this.builderRegistry, authentication));
    }

    private BuilderDockerConfiguration customizePublishAuthentication(Log log, BuilderDockerConfiguration dockerConfiguration, boolean publish) {
        if (!publish) {
            return dockerConfiguration;
        }
        DockerRegistryAuthentication authentication = DockerRegistryAuthentication.configuration((DockerRegistryAuthentication)DockerRegistryAuthentication.EMPTY_USER, (message, ex) -> log.warn((CharSequence)message));
        return dockerConfiguration.withPublishRegistryAuthentication(this.getRegistryAuthentication("publish", this.publishRegistry, authentication));
    }

    private DockerRegistryAuthentication getRegistryAuthentication(String type, @Nullable DockerRegistry registry, DockerRegistryAuthentication fallback) {
        if (registry == null || registry.isEmpty()) {
            return fallback;
        }
        if (registry.hasTokenAuth() && !registry.hasUserAuth()) {
            String token = registry.getToken();
            Assert.state((token != null ? 1 : 0) != 0, (String)"'token' must not be null");
            return DockerRegistryAuthentication.token((String)token);
        }
        if (registry.hasUserAuth() && !registry.hasTokenAuth()) {
            String username = registry.getUsername();
            String password = registry.getPassword();
            Assert.state((username != null ? 1 : 0) != 0, (String)"'username' must not be null");
            Assert.state((password != null ? 1 : 0) != 0, (String)"'password' must not be null");
            return DockerRegistryAuthentication.user((String)username, (String)password, (String)registry.getUrl(), (String)registry.getEmail());
        }
        throw new IllegalArgumentException("Invalid Docker " + type + " registry configuration, either token or username/password must be provided");
    }

    public static class DockerRegistry {
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String url;
        private @Nullable String email;
        private @Nullable String token;

        public DockerRegistry() {
        }

        public DockerRegistry(@Nullable String username, @Nullable String password, @Nullable String url, @Nullable String email) {
            this.username = username;
            this.password = password;
            this.url = url;
            this.email = email;
        }

        public DockerRegistry(String token) {
            this.token = token;
        }

        public @Nullable String getUsername() {
            return this.username;
        }

        void setUsername(@Nullable String username) {
            this.username = username;
        }

        public @Nullable String getPassword() {
            return this.password;
        }

        void setPassword(@Nullable String password) {
            this.password = password;
        }

        public @Nullable String getEmail() {
            return this.email;
        }

        void setEmail(@Nullable String email) {
            this.email = email;
        }

        @Nullable String getUrl() {
            return this.url;
        }

        void setUrl(@Nullable String url) {
            this.url = url;
        }

        public @Nullable String getToken() {
            return this.token;
        }

        void setToken(@Nullable String token) {
            this.token = token;
        }

        boolean isEmpty() {
            return this.username == null && this.password == null && this.url == null && this.email == null && this.token == null;
        }

        boolean hasTokenAuth() {
            return this.token != null;
        }

        boolean hasUserAuth() {
            return this.username != null && this.password != null;
        }
    }
}

