/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics;

import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.config.validate.ValidationException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

class ValidationFailureAnalyzer
extends AbstractFailureAnalyzer<ValidationException> {
    ValidationFailureAnalyzer() {
    }

    protected FailureAnalysis analyze(Throwable rootFailure, ValidationException cause) {
        StringBuilder description = new StringBuilder(String.format("Invalid Micrometer configuration detected:%n", new Object[0]));
        for (Validated.Invalid failure : cause.getValidation().failures()) {
            description.append(String.format("%n  - %s was '%s' but it %s", failure.getProperty(), failure.getValue(), failure.getMessage()));
        }
        return new FailureAnalysis(description.toString(), "Update your application to correct the invalid configuration.", (Throwable)cause);
    }
}

