/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.properties;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class PropertiesConfigAdapter<T> {
    protected final T properties;

    public PropertiesConfigAdapter(T properties) {
        Assert.notNull(properties, (String)"'properties' must not be null");
        this.properties = properties;
    }

    protected final <V> @Nullable V get(Getter<T, V> getter, Supplier<@Nullable V> fallback) {
        V value = getter.get(this.properties);
        return value != null ? value : fallback.get();
    }

    protected final <V> V getRequired(Getter<T, V> getter, Supplier<V> fallback) {
        V value = getter.get(this.properties);
        if (value != null) {
            return value;
        }
        V fallbackValue = fallback.get();
        Assert.state((fallbackValue != null ? 1 : 0) != 0, (String)"'fallbackValue' must not be null");
        return fallbackValue;
    }

    protected static interface Getter<T, V> {
        public @Nullable V get(T var1);
    }
}

