/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.jmx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.jmx.JmxProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.jmx.JmxPropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={JmxMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="jmx")
@EnableConfigurationProperties(value={JmxProperties.class})
public final class JmxMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    JmxConfig jmxConfig(JmxProperties jmxProperties) {
        return new JmxPropertiesConfigAdapter(jmxProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    JmxMeterRegistry jmxMeterRegistry(JmxConfig jmxConfig, Clock clock) {
        return new JmxMeterRegistry(jmxConfig, clock);
    }
}

