/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.prometheus.metrics.exporter.pushgateway.Format;
import io.prometheus.metrics.exporter.pushgateway.PushGateway;
import io.prometheus.metrics.exporter.pushgateway.Scheme;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.tracer.common.SpanContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.MutuallyExclusiveConfigurationPropertiesException;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.prometheus.PrometheusProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.prometheus.PrometheusPropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.micrometer.metrics.export.prometheus.PrometheusPushGatewayManager;
import org.springframework.boot.micrometer.metrics.export.prometheus.endpoint.PrometheusScrapeEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="prometheus")
@EnableConfigurationProperties(value={PrometheusProperties.class})
public final class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    PrometheusConfig prometheusConfig(PrometheusProperties prometheusProperties) {
        return new PrometheusPropertiesConfigAdapter(prometheusProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig prometheusConfig, PrometheusRegistry prometheusRegistry, Clock clock, ObjectProvider<SpanContext> spanContext) {
        return new PrometheusMeterRegistry(prometheusConfig, prometheusRegistry, clock, (SpanContext)spanContext.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    PrometheusRegistry prometheusRegistry() {
        return new PrometheusRegistry();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={PushGateway.class})
    @ConditionalOnBooleanProperty(value={"management.prometheus.metrics.export.pushgateway.enabled"})
    static class PrometheusPushGatewayConfiguration {
        private static final String FALLBACK_JOB = "spring";

        PrometheusPushGatewayConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        PrometheusPushGatewayManager prometheusPushGatewayManager(PrometheusRegistry registry, PrometheusProperties prometheusProperties, Environment environment) {
            PrometheusProperties.Pushgateway properties = prometheusProperties.getPushgateway();
            PushGateway pushGateway = this.initializePushGateway(registry, properties, environment);
            return new PrometheusPushGatewayManager(pushGateway, properties.getPushRate(), properties.getShutdownOperation());
        }

        private PushGateway initializePushGateway(PrometheusRegistry registry, PrometheusProperties.Pushgateway properties, Environment environment) {
            PushGateway.Builder builder = PushGateway.builder().address(properties.getAddress()).scheme(this.scheme(properties)).format(this.format(properties)).job(this.getJob(properties, environment)).registry(registry);
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleNonNullValuesIn(entries -> {
                entries.put("management.prometheus.metrics.export.pushgateway.token", properties.getToken());
                entries.put("management.prometheus.metrics.export.pushgateway.username", properties.getUsername());
            });
            if (StringUtils.hasText((String)properties.getToken())) {
                builder.bearerToken(properties.getToken());
            } else if (StringUtils.hasText((String)properties.getUsername())) {
                builder.basicAuth(properties.getUsername(), properties.getPassword());
            }
            properties.getGroupingKey().forEach((arg_0, arg_1) -> ((PushGateway.Builder)builder).groupingKey(arg_0, arg_1));
            return builder.build();
        }

        private Scheme scheme(PrometheusProperties.Pushgateway properties) {
            return switch (properties.getScheme()) {
                default -> throw new IncompatibleClassChangeError();
                case PrometheusProperties.Pushgateway.Scheme.HTTP -> Scheme.HTTP;
                case PrometheusProperties.Pushgateway.Scheme.HTTPS -> Scheme.HTTPS;
            };
        }

        private Format format(PrometheusProperties.Pushgateway properties) {
            return switch (properties.getFormat()) {
                default -> throw new IncompatibleClassChangeError();
                case PrometheusProperties.Pushgateway.Format.PROTOBUF -> Format.PROMETHEUS_PROTOBUF;
                case PrometheusProperties.Pushgateway.Format.TEXT -> Format.PROMETHEUS_TEXT;
            };
        }

        private String getJob(PrometheusProperties.Pushgateway properties, Environment environment) {
            String job = properties.getJob();
            return job != null ? job : environment.getProperty("spring.application.name", FALLBACK_JOB);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnAvailableEndpoint(value=PrometheusScrapeEndpoint.class)
    static class PrometheusScrapeEndpointConfiguration {
        PrometheusScrapeEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        PrometheusScrapeEndpoint prometheusEndpoint(PrometheusRegistry prometheusRegistry, PrometheusConfig prometheusConfig) {
            return new PrometheusScrapeEndpoint(prometheusRegistry, prometheusConfig.prometheusProperties());
        }
    }
}

