/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.annotation.DeterminableImports;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ReflectionUtils;

class ImportsContextCustomizer
implements ContextCustomizer {
    static final String TEST_CLASS_ATTRIBUTE = "testClass";
    private final Class<?> testClass;
    private final ContextCustomizerKey key;

    ImportsContextCustomizer(Class<?> testClass) {
        this.testClass = testClass;
        this.key = new ContextCustomizerKey(testClass);
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        BeanDefinitionRegistry registry = this.getBeanDefinitionRegistry((ApplicationContext)context);
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        this.registerCleanupPostProcessor(registry, reader);
        this.registerImportsConfiguration(registry, reader);
    }

    private void registerCleanupPostProcessor(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader) {
        BeanDefinition definition = this.registerBean(registry, reader, ImportsCleanupPostProcessor.BEAN_NAME, ImportsCleanupPostProcessor.class);
        definition.setRole(2);
        definition.getConstructorArgumentValues().addIndexedArgumentValue(0, this.testClass);
    }

    private void registerImportsConfiguration(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader) {
        BeanDefinition definition = this.registerBean(registry, reader, ImportsConfiguration.BEAN_NAME, ImportsConfiguration.class);
        definition.setAttribute(TEST_CLASS_ATTRIBUTE, this.testClass);
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    private BeanDefinition registerBean(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader, String beanName, Class<?> type) {
        reader.registerBean(type, beanName);
        return registry.getBeanDefinition(beanName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImportsContextCustomizer other = (ImportsContextCustomizer)obj;
        return this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("key", (Object)this.key).toString();
    }

    static class ContextCustomizerKey {
        private static final Class<?>[] NO_IMPORTS = new Class[0];
        private static final Set<AnnotationFilter> ANNOTATION_FILTERS;
        private final Set<Object> key;

        ContextCustomizerKey(Class<?> testClass) {
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            HashSet seen = new HashSet();
            this.collectClassAnnotations(testClass, annotations, seen);
            Set<Object> determinedImports = this.determineImports(annotations, testClass);
            this.key = Collections.unmodifiableSet(determinedImports != null ? determinedImports : annotations);
        }

        private void collectClassAnnotations(Class<?> classType, Set<Annotation> annotations, Set<Class<?>> seen) {
            if (seen.add(classType)) {
                this.collectElementAnnotations(classType, annotations, seen);
                for (Class<?> interfaceType : classType.getInterfaces()) {
                    this.collectClassAnnotations(interfaceType, annotations, seen);
                }
                if (classType.getSuperclass() != null) {
                    this.collectClassAnnotations(classType.getSuperclass(), annotations, seen);
                }
            }
        }

        private void collectElementAnnotations(AnnotatedElement element, Set<Annotation> annotations, Set<Class<?>> seen) {
            for (Annotation annotation : element.getDeclaredAnnotations()) {
                if (this.isIgnoredAnnotation(annotation)) continue;
                annotations.add(annotation);
                this.collectClassAnnotations(annotation.annotationType(), annotations, seen);
            }
        }

        private boolean isIgnoredAnnotation(Annotation annotation) {
            for (AnnotationFilter annotationFilter : ANNOTATION_FILTERS) {
                if (!annotationFilter.isIgnored(annotation)) continue;
                return true;
            }
            return false;
        }

        private Set<Object> determineImports(Set<Annotation> annotations, Class<?> testClass) {
            LinkedHashSet<Object> determinedImports = new LinkedHashSet<Object>();
            AnnotationMetadata testClassMetadata = AnnotationMetadata.introspect(testClass);
            for (Annotation annotation : annotations) {
                for (Class<?> source : this.getImports(annotation)) {
                    Set<Object> determinedSourceImports = this.determineImports(source, testClassMetadata);
                    if (determinedSourceImports == null) {
                        return null;
                    }
                    determinedImports.addAll(determinedSourceImports);
                }
            }
            return determinedImports;
        }

        private Class<?>[] getImports(Annotation annotation) {
            if (annotation instanceof Import) {
                return ((Import)annotation).value();
            }
            return NO_IMPORTS;
        }

        private Set<Object> determineImports(Class<?> source, AnnotationMetadata metadata) {
            if (DeterminableImports.class.isAssignableFrom(source)) {
                return ((DeterminableImports)this.instantiate(source)).determineImports(metadata);
            }
            if (ImportSelector.class.isAssignableFrom(source) || ImportBeanDefinitionRegistrar.class.isAssignableFrom(source)) {
                return null;
            }
            return Collections.singleton(source.getName());
        }

        private <T> T instantiate(Class<T> source) {
            try {
                Constructor<T> constructor = source.getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(constructor);
                return constructor.newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to instantiate DeterminableImportSelector " + source.getName(), ex);
            }
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.key.equals(((ContextCustomizerKey)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }

        static {
            HashSet<AnnotationFilter> filters = new HashSet<AnnotationFilter>();
            filters.add(new JavaLangAnnotationFilter());
            filters.add(new KotlinAnnotationFilter());
            filters.add(new SpockAnnotationFilter());
            filters.add(new JUnitAnnotationFilter());
            ANNOTATION_FILTERS = Collections.unmodifiableSet(filters);
        }
    }

    @Order(value=0x7FFFFFFF)
    static class ImportsCleanupPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        static final String BEAN_NAME = ImportsCleanupPostProcessor.class.getName();
        private final Class<?> testClass;

        ImportsCleanupPostProcessor(Class<?> testClass) {
            this.testClass = testClass;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            try {
                String[] names;
                for (String name : names = registry.getBeanDefinitionNames()) {
                    BeanDefinition definition = registry.getBeanDefinition(name);
                    if (!this.testClass.getName().equals(definition.getBeanClassName())) continue;
                    registry.removeBeanDefinition(name);
                }
                registry.removeBeanDefinition(ImportsConfiguration.BEAN_NAME);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ImportsSelector.class})
    static class ImportsConfiguration {
        static final String BEAN_NAME = ImportsConfiguration.class.getName();

        ImportsConfiguration() {
        }
    }

    private static final class JUnitAnnotationFilter
    implements AnnotationFilter {
        private JUnitAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return annotation.annotationType().getName().startsWith("org.junit.");
        }
    }

    private static final class SpockAnnotationFilter
    implements AnnotationFilter {
        private SpockAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return annotation.annotationType().getName().startsWith("org.spockframework.") || annotation.annotationType().getName().startsWith("spock.");
        }
    }

    private static final class KotlinAnnotationFilter
    implements AnnotationFilter {
        private KotlinAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return "kotlin.Metadata".equals(annotation.annotationType().getName()) || this.isInKotlinAnnotationPackage(annotation);
        }

        private boolean isInKotlinAnnotationPackage(Annotation annotation) {
            return annotation.annotationType().getName().startsWith("kotlin.annotation.");
        }
    }

    private static final class JavaLangAnnotationFilter
    implements AnnotationFilter {
        private JavaLangAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation);
        }
    }

    private static interface AnnotationFilter {
        public boolean isIgnored(Annotation var1);
    }

    static class ImportsSelector
    implements ImportSelector,
    BeanFactoryAware {
        private static final String[] NO_IMPORTS = new String[0];
        private ConfigurableListableBeanFactory beanFactory;

        ImportsSelector() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            Object testClass;
            BeanDefinition definition = this.beanFactory.getBeanDefinition(ImportsConfiguration.BEAN_NAME);
            Object object = testClass = definition != null ? definition.getAttribute(ImportsContextCustomizer.TEST_CLASS_ATTRIBUTE) : null;
            if (testClass != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ((Class)testClass).getName();
            } else {
                stringArray = NO_IMPORTS;
            }
            return stringArray;
        }
    }
}

