/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.boot.test.context.ReactiveWebMergedContextConfiguration;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTestAnnotation;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.aot.AotTestAttributes;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringBootTestContextBootstrapper
extends DefaultTestContextBootstrapper {
    private static final String ACTIVATE_SERVLET_LISTENER = "org.springframework.test.context.web.ServletTestExecutionListener.activateListener";
    private static final Log logger = LogFactory.getLog(SpringBootTestContextBootstrapper.class);
    private final AotTestAttributes aotTestAttributes;

    public SpringBootTestContextBootstrapper() {
        this(AotTestAttributes.getInstance());
    }

    SpringBootTestContextBootstrapper(AotTestAttributes aotTestAttributes) {
        this.aotTestAttributes = aotTestAttributes;
    }

    public TestContext buildTestContext() {
        TestContext context = super.buildTestContext();
        this.verifyConfiguration(context.getTestClass());
        SpringBootTest.WebEnvironment webEnvironment = this.getWebEnvironment(context.getTestClass());
        if (webEnvironment == SpringBootTest.WebEnvironment.MOCK && WebApplicationType.deduce() == WebApplicationType.SERVLET) {
            context.setAttribute(ACTIVATE_SERVLET_LISTENER, (Object)true);
        } else if (webEnvironment != null && webEnvironment.isEmbedded()) {
            context.setAttribute(ACTIVATE_SERVLET_LISTENER, (Object)false);
        }
        return context;
    }

    protected ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Object[] classes = this.getClasses(testClass);
        if (!ObjectUtils.isEmpty((Object[])classes)) {
            for (ContextConfigurationAttributes configAttributes : configAttributesList) {
                this.addConfigAttributesClasses(configAttributes, (Class<?>[])classes);
            }
        }
        return super.resolveContextLoader(testClass, configAttributesList);
    }

    private void addConfigAttributesClasses(ContextConfigurationAttributes configAttributes, Class<?>[] classes) {
        LinkedHashSet combined = new LinkedHashSet(Arrays.asList(classes));
        if (configAttributes.getClasses() != null) {
            combined.addAll(Arrays.asList(configAttributes.getClasses()));
        }
        configAttributes.setClasses(ClassUtils.toClassArray(combined));
    }

    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        return SpringBootContextLoader.class;
    }

    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        List<String> propertySourceProperties;
        Class<?>[] classes = this.getOrFindConfigurationClasses(mergedConfig);
        SpringBootTest.WebEnvironment webEnvironment = this.getWebEnvironment((mergedConfig = this.createModifiedConfig(mergedConfig, classes, StringUtils.toStringArray(propertySourceProperties = this.getAndProcessPropertySourceProperties(mergedConfig)))).getTestClass());
        if (webEnvironment != null && this.isWebEnvironmentSupported(mergedConfig)) {
            WebApplicationType webApplicationType = this.getWebApplicationType(mergedConfig);
            if (webApplicationType == WebApplicationType.SERVLET && (webEnvironment.isEmbedded() || webEnvironment == SpringBootTest.WebEnvironment.MOCK)) {
                mergedConfig = new WebMergedContextConfiguration(mergedConfig, this.determineResourceBasePath(mergedConfig));
            } else if (webApplicationType == WebApplicationType.REACTIVE && (webEnvironment.isEmbedded() || webEnvironment == SpringBootTest.WebEnvironment.MOCK)) {
                return new ReactiveWebMergedContextConfiguration(mergedConfig);
            }
        }
        return mergedConfig;
    }

    private WebApplicationType getWebApplicationType(MergedContextConfiguration configuration) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(TestPropertySourceUtils.convertInlinedPropertiesToMap((String[])configuration.getPropertySourceProperties()));
        Binder binder = new Binder(new ConfigurationPropertySource[]{source});
        return (WebApplicationType)binder.bind("spring.main.web-application-type", Bindable.of(WebApplicationType.class)).orElseGet(WebApplicationType::deduce);
    }

    protected String determineResourceBasePath(MergedContextConfiguration configuration) {
        return MergedAnnotations.from((AnnotatedElement)configuration.getTestClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(WebAppConfiguration.class).getValue("value", String.class).orElse("src/main/webapp");
    }

    private boolean isWebEnvironmentSupported(MergedContextConfiguration mergedConfig) {
        Class testClass = mergedConfig.getTestClass();
        ContextHierarchy hierarchy = (ContextHierarchy)AnnotationUtils.getAnnotation((AnnotatedElement)testClass, ContextHierarchy.class);
        if (hierarchy == null || hierarchy.value().length == 0) {
            return true;
        }
        ContextConfiguration[] configurations = hierarchy.value();
        return this.isFromConfiguration(mergedConfig, configurations[configurations.length - 1]);
    }

    private boolean isFromConfiguration(MergedContextConfiguration candidateConfig, ContextConfiguration configuration) {
        ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(candidateConfig.getTestClass(), configuration);
        HashSet<Class> configurationClasses = new HashSet<Class>(Arrays.asList(attributes.getClasses()));
        for (Class candidate : candidateConfig.getClasses()) {
            if (!configurationClasses.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    protected Class<?>[] getOrFindConfigurationClasses(MergedContextConfiguration mergedConfig) {
        Class[] classes = mergedConfig.getClasses();
        if (this.containsNonTestComponent(classes) || mergedConfig.hasLocations()) {
            return classes;
        }
        Class<?> found = this.findConfigurationClass(mergedConfig.getTestClass());
        logger.info((Object)("Found @SpringBootConfiguration " + found.getName() + " for test " + String.valueOf(mergedConfig.getTestClass())));
        return this.merge(found, classes);
    }

    private Class<?> findConfigurationClass(Class<?> testClass) {
        String propertyName = "%s.SpringBootConfiguration.%s".formatted(SpringBootTestContextBootstrapper.class.getName(), testClass.getName());
        String foundClassName = this.aotTestAttributes.getString(propertyName);
        if (foundClassName != null) {
            return ClassUtils.resolveClassName((String)foundClassName, (ClassLoader)testClass.getClassLoader());
        }
        Class<?> found = new AnnotatedClassFinder(SpringBootConfiguration.class).findFromClass(testClass);
        Assert.state((found != null ? 1 : 0) != 0, (String)"Unable to find a @SpringBootConfiguration by searching packages upwards from the test. You can use @ContextConfiguration, @SpringBootTest(classes=...) or other Spring Test supported mechanisms to explicitly declare the configuration classes to load. Classes annotated with @TestConfiguration are not considered.");
        this.aotTestAttributes.setAttribute(propertyName, found.getName());
        return found;
    }

    private boolean containsNonTestComponent(Class<?>[] classes) {
        for (Class<?> candidate : classes) {
            if (MergedAnnotations.from(candidate, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).isPresent(TestConfiguration.class)) continue;
            return true;
        }
        return false;
    }

    private Class<?>[] merge(Class<?> head, Class<?>[] existing) {
        Class[] result = new Class[existing.length + 1];
        result[0] = head;
        System.arraycopy(existing, 0, result, 1, existing.length);
        return result;
    }

    private List<String> getAndProcessPropertySourceProperties(MergedContextConfiguration mergedConfig) {
        ArrayList<String> propertySourceProperties = new ArrayList<String>(Arrays.asList(mergedConfig.getPropertySourceProperties()));
        String differentiator = this.getDifferentiatorPropertySourceProperty();
        if (differentiator != null) {
            propertySourceProperties.add(differentiator);
        }
        this.processPropertySourceProperties(mergedConfig, propertySourceProperties);
        return propertySourceProperties;
    }

    protected @Nullable String getDifferentiatorPropertySourceProperty() {
        return ((Object)((Object)this)).getClass().getName() + "=true";
    }

    protected void processPropertySourceProperties(MergedContextConfiguration mergedConfig, List<String> propertySourceProperties) {
        SpringBootTest.WebEnvironment webEnvironment;
        Class testClass = mergedConfig.getTestClass();
        Object[] properties = this.getProperties(testClass);
        if (!ObjectUtils.isEmpty((Object[])properties)) {
            propertySourceProperties.addAll(0, Arrays.asList(properties));
        }
        if ((webEnvironment = this.getWebEnvironment(testClass)) == SpringBootTest.WebEnvironment.RANDOM_PORT) {
            propertySourceProperties.add("server.port=0");
        } else if (webEnvironment == SpringBootTest.WebEnvironment.NONE) {
            propertySourceProperties.add("spring.main.web-application-type=none");
        }
    }

    protected @Nullable SpringBootTest.WebEnvironment getWebEnvironment(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation != null ? annotation.webEnvironment() : null;
    }

    protected Class<?> @Nullable [] getClasses(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation != null ? annotation.classes() : null;
    }

    protected String @Nullable [] getProperties(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation != null ? annotation.properties() : null;
    }

    protected @Nullable SpringBootTest getAnnotation(Class<?> testClass) {
        return (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class);
    }

    protected void verifyConfiguration(Class<?> testClass) {
        SpringBootTest springBootTest = this.getAnnotation(testClass);
        if (springBootTest != null && this.isListeningOnPort(springBootTest.webEnvironment()) && MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).isPresent(WebAppConfiguration.class)) {
            throw new IllegalStateException("@WebAppConfiguration should only be used with @SpringBootTest when @SpringBootTest is configured with a mock web environment. Please remove @WebAppConfiguration or reconfigure @SpringBootTest.");
        }
    }

    private boolean isListeningOnPort(SpringBootTest.WebEnvironment webEnvironment) {
        return webEnvironment == SpringBootTest.WebEnvironment.DEFINED_PORT || webEnvironment == SpringBootTest.WebEnvironment.RANDOM_PORT;
    }

    protected final MergedContextConfiguration createModifiedConfig(MergedContextConfiguration mergedConfig, Class<?>[] classes) {
        return this.createModifiedConfig(mergedConfig, classes, mergedConfig.getPropertySourceProperties());
    }

    protected final MergedContextConfiguration createModifiedConfig(MergedContextConfiguration mergedConfig, Class<?>[] classes, String[] propertySourceProperties) {
        LinkedHashSet<SpringBootTestAnnotation> contextCustomizers = new LinkedHashSet<SpringBootTestAnnotation>(mergedConfig.getContextCustomizers());
        contextCustomizers.add(new SpringBootTestAnnotation(mergedConfig.getTestClass()));
        return new MergedContextConfiguration(mergedConfig.getTestClass(), mergedConfig.getLocations(), (Class[])classes, mergedConfig.getContextInitializerClasses(), mergedConfig.getActiveProfiles(), mergedConfig.getPropertySourceDescriptors(), propertySourceProperties, contextCustomizers, mergedConfig.getContextLoader(), this.getCacheAwareContextLoaderDelegate(), mergedConfig.getParent());
    }
}

