/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;

class FilteringStatusListener
extends ContextAwareBase
implements StatusListener,
LifeCycle {
    private final StatusListener delegate;
    private final int levelThreshold;

    FilteringStatusListener(StatusListener delegate, int levelThreshold) {
        this.delegate = delegate;
        this.levelThreshold = levelThreshold;
    }

    public void addStatusEvent(Status status) {
        if (status.getLevel() >= this.levelThreshold) {
            this.delegate.addStatusEvent(status);
        }
    }

    public boolean isResetResistant() {
        return this.delegate.isResetResistant();
    }

    public void start() {
        StatusListener statusListener = this.delegate;
        if (statusListener instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)statusListener;
            lifeCycle.start();
        }
    }

    public void stop() {
        StatusListener statusListener = this.delegate;
        if (statusListener instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)statusListener;
            lifeCycle.stop();
        }
    }

    public boolean isStarted() {
        StatusListener statusListener = this.delegate;
        if (statusListener instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)statusListener;
            return lifeCycle.isStarted();
        }
        return true;
    }
}

