/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.boot.ssl.pem.LoadedPemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public interface PemSslStore {
    public @Nullable String type();

    public @Nullable String alias();

    public @Nullable String password();

    public @Nullable List<X509Certificate> certificates();

    public @Nullable PrivateKey privateKey();

    default public PemSslStore withAlias(@Nullable String alias) {
        List<X509Certificate> certificates = this.certificates();
        Assert.notNull(certificates, (String)"'certificates' must not be null");
        return PemSslStore.of(this.type(), alias, this.password(), certificates, this.privateKey());
    }

    default public PemSslStore withPassword(@Nullable String password) {
        List<X509Certificate> certificates = this.certificates();
        Assert.notNull(certificates, (String)"'certificates' must not be null");
        return PemSslStore.of(this.type(), this.alias(), password, certificates, this.privateKey());
    }

    public static @Nullable PemSslStore load(@Nullable PemSslStoreDetails details) {
        return PemSslStore.load(details, ApplicationResourceLoader.get());
    }

    public static @Nullable PemSslStore load(@Nullable PemSslStoreDetails details, ResourceLoader resourceLoader) {
        if (details == null || details.isEmpty()) {
            return null;
        }
        return new LoadedPemSslStore(details, resourceLoader);
    }

    public static PemSslStore of(@Nullable String type, List<X509Certificate> certificates, @Nullable PrivateKey privateKey) {
        return PemSslStore.of(type, null, null, certificates, privateKey);
    }

    public static PemSslStore of(List<X509Certificate> certificates, @Nullable PrivateKey privateKey) {
        return PemSslStore.of(null, null, null, certificates, privateKey);
    }

    public static PemSslStore of(final @Nullable String type, final @Nullable String alias, final @Nullable String password, final List<X509Certificate> certificates, final @Nullable PrivateKey privateKey) {
        Assert.notEmpty(certificates, (String)"'certificates' must not be empty");
        return new PemSslStore(){

            @Override
            public @Nullable String type() {
                return type;
            }

            @Override
            public @Nullable String alias() {
                return alias;
            }

            @Override
            public @Nullable String password() {
                return password;
            }

            @Override
            public List<X509Certificate> certificates() {
                return certificates;
            }

            @Override
            public @Nullable PrivateKey privateKey() {
                return privateKey;
            }
        };
    }
}

