/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.BusPathMatcher;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.DefaultBusPathMatcher;
import org.springframework.cloud.bus.PathServiceMatcher;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@EnableConfigurationProperties(value={BusProperties.class})
public class PathServiceMatcherAutoConfiguration {
    public static final String BUS_PATH_MATCHER_NAME = "busPathMatcher";
    public static final String CLOUD_CONFIG_NAME_PROPERTY = "spring.cloud.config.name";

    @BusPathMatcher
    @ConditionalOnMissingBean(name={"busPathMatcher"})
    @Bean(name={"busPathMatcher"})
    public PathMatcher busPathMatcher() {
        return new DefaultBusPathMatcher((PathMatcher)new AntPathMatcher(":"));
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceMatcher.class})
    public PathServiceMatcher pathServiceMatcher(@BusPathMatcher PathMatcher pathMatcher, BusProperties properties, Environment environment) {
        String[] configNames = (String[])environment.getProperty(CLOUD_CONFIG_NAME_PROPERTY, String[].class, (Object)new String[0]);
        return new PathServiceMatcher(pathMatcher, properties.getId(), configNames);
    }
}

